/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.sql.SQL;
import java.sql.ResultSet;
import java.sql.Time;
import java.util.Date;

public class TimeMapping
extends InstanceVarMapping {
    public TimeMapping(PropertiedObject.Property name) {
        super(name);
    }

    public TimeMapping(PropertiedObject.Property newProperty, String newCol) {
        super(newProperty, newCol);
    }

    public TimeMapping(PropertiedObject.Property newProperty, String newCol, String tableName) {
        super(newProperty, newCol, tableName);
    }

    @Override
    public Object getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        Date value = (Date)super.getDBValueFromSnapshot(snapshot);
        return value == null ? null : new Time(value.getTime());
    }

    @Override
    public Object getFromResultSet(ResultSet rs) throws Exception {
        Time toReturn = null;
        String colName = SQL.supportsTableNameColumnSelection() && this.getTable() != null ? this.getTable() + "." + this.getCol() : this.getCol();
        if (rs.getObject(colName) != null) {
            Object value = rs.getObject(colName);
            if (value instanceof Time) {
                toReturn = (Time)value;
            } else if (value instanceof String) {
                toReturn = Time.valueOf((String)value);
            }
        }
        return toReturn;
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        Time value;
        if (dbValue == null) {
            value = null;
        } else if (dbValue instanceof Date) {
            value = new Time(((Date)dbValue).getTime());
        } else {
            throw new IllegalArgumentException("The type of " + dbValue + " should be a sql Time, got a " + dbValue.getClass().getName());
        }
        super.setObjectFieldFromDBValue(owner, value);
    }
}

