/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampMapping
extends InstanceVarMapping {
    private final SimpleDateFormat sqlFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean allowNulls = false;

    public TimestampMapping(PropertiedObject.Property name) {
        super(name);
    }

    public TimestampMapping(PropertiedObject.Property newProperty, String newCol) {
        super(newProperty, newCol);
    }

    public TimestampMapping(PropertiedObject.Property newProperty, String newCol, String tableName) {
        super(newProperty, newCol, tableName);
    }

    @Override
    public Object getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        Object timeStamp = super.getDBValueFromSnapshot(snapshot);
        if (timeStamp == null && !this.allowNulls) {
            timeStamp = new Timestamp(System.currentTimeMillis());
        } else if (timeStamp instanceof Date) {
            timeStamp = new Timestamp(((Date)timeStamp).getTime());
        }
        return timeStamp;
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        Object valueToUse = dbValue;
        if (dbValue instanceof Date) {
            valueToUse = new Date(((Date)dbValue).getTime());
        } else if (dbValue instanceof String) {
            valueToUse = this.sqlFormat.parse(dbValue.toString());
        }
        super.setObjectFieldFromDBValue(owner, valueToUse);
    }

    @Override
    public boolean useInHasChanged() {
        return false;
    }

    public TimestampMapping setAllowNulls(boolean allowed) {
        this.allowNulls = allowed;
        return this;
    }
}

