/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.datasourcefactory;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.database.datasourcefactory.DataSourceFactory;
import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;

public class ConfigDataSourceFactory
implements DataSourceFactory {
    private static ConfigDataSourceFactory instance = new ConfigDataSourceFactory();
    private DataSource dataSource;

    private ConfigDataSourceFactory() {
    }

    public static DataSourceFactory getInstance() {
        return instance;
    }

    @Override
    public synchronized DataSource constructDataSource() {
        if (this.dataSource == null) {
            MysqlConnectionPoolDataSource cpDS = new MysqlConnectionPoolDataSource();
            cpDS.setUser(Config.getDecryptedStringValue("database_username"));
            cpDS.setPassword(Config.getDecryptedStringValue("database_password"));
            String port = Config.getStringValue("database_port");
            port = port != null && !port.isEmpty() ? ":" + port : ":3307";
            String dbPrefix = Config.getStringValue("database_prefix") + "://" + Config.getStringValue("database_server") + port + "/";
            String dbName = Config.getStringValue("database_name");
            cpDS.setUrl(dbPrefix + dbName);
            SharedPoolDataSource sharedDataSource = new SharedPoolDataSource();
            sharedDataSource.setConnectionPoolDataSource((ConnectionPoolDataSource)cpDS);
            sharedDataSource.setMaxActive(-1);
            sharedDataSource.setMaxWait(100);
            this.dataSource = sharedDataSource;
        }
        return this.dataSource;
    }
}

