/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.idgeneration;

import au.com.ordermate.persistence.database.idgeneration.IDGenerationStrategy;
import java.sql.ResultSet;
import java.sql.SQLException;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;

public class NextInStoreGroupStrategy
implements IDGenerationStrategy {
    private final String table;
    private final String query;

    public NextInStoreGroupStrategy(String tableName) {
        this.table = tableName;
        if (this.table == null || this.table.isEmpty()) {
            throw new IllegalStateException("Cannot possibly get id value unless the class map is specified");
        }
        StringBuilder SB = new StringBuilder("SELECT (MAX(id) + 1) AS 'next_id' from ").append(this.table).append(" WHERE id < 1000000000");
        this.query = SB.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long generateNextId(DBConnectionInterface dc) {
        Long value = null;
        ResultSet rs = null;
        try {
            rs = dc.executeQuery(this.query);
            rs.next();
            value = rs.getLong(1);
            if (value == null || value == 0L) {
                OrderMate.LOG.info("Setting the id to 1 since it came back as zero for " + this.table);
                value = 1L;
            }
        }
        catch (SQLException ex) {
            OrderMate.LOG.warn("Couldn't get the next id.", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex2) {
                    OrderMate.LOG.warn("Couldn't close off the resultSet after failing with id generation.", (Throwable)ex2);
                }
            }
        }
        return value;
    }
}

