/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.priority;

import au.com.ordermate.persistence.database.priority.SnapshotPriorityAssigner;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.departments.Payrate;
import ordermate.database.feedback.FeedbackAnswer;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.gui.GuiConfig;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.misc.Course;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.upsell.UpsellItem;
import ordermate.database.users.User;

public class DefaultPriorityAssigner
implements SnapshotPriorityAssigner {
    private final Map<String, Integer> priorityArchive = new HashMap<String, Integer>();

    public DefaultPriorityAssigner() {
        this.prioritise(9, User.class, Terminal.class);
        this.prioritise(8, Payrate.class, TaxCode.class, PhysicalTable.class);
        this.prioritise(7, InventoryItem.class, AbstractTrigger.class, InventoryCoupon.class, InventoryCombo.class, TradingDay.class);
        this.prioritise(6, InventoryPriceAdjustment.class, AbstractDebtor.class);
        this.prioritise(5, Course.class, Shift.class, CashTransaction.class);
        this.prioritise(3, FeedbackAnswer.class, DeliveryZone.class, Account.class);
        this.prioritise(2, FinanceTimesheet.class, GuiConfig.class);
        this.prioritise(1, UpsellItem.class);
    }

    private void prioritise(int value, Class ... clazzes) {
        Integer priority = value;
        for (Class clazz : clazzes) {
            this.priorityArchive.put(clazz.getName(), priority);
            if (this.priorityArchive.containsKey(clazz.getPackage().getName())) continue;
            this.priorityArchive.put(clazz.getPackage().getName(), priority);
        }
    }

    @Override
    public int assignPriority(SynchronisationSnapshot toCast) {
        Integer priority = this.findPriority(toCast);
        return priority == null ? 4 : priority;
    }

    protected Integer findPriority(SynchronisationSnapshot toCast) {
        String className = toCast.getObjectType();
        if (!this.priorityArchive.containsKey(className) && className.contains(".")) {
            String thePackage = className.substring(0, className.lastIndexOf("."));
            this.priorityArchive.put(className, this.priorityArchive.get(thePackage));
        }
        return this.priorityArchive.get(className);
    }
}

