/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.list;

import au.com.ordermate.persistence.AbstractPersistentList;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.SuperSaveable;
import au.com.ordermate.reflect.FieldUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractPersistentWriteableList<E extends PersistentObjectI & SuperSaveable>
extends AbstractPersistentList<E>
implements PersistentWriteableList<E> {
    protected volatile Set<E> deleteSet = new HashSet(2);
    private boolean tearDownLinkBack = true;

    public AbstractPersistentWriteableList() {
    }

    public AbstractPersistentWriteableList(Class<E> listType) {
        super(listType);
    }

    public AbstractPersistentWriteableList(Class<E> listType, PropertiedObject.Property newLinkBack) {
        super(listType);
        this.linkBack(newLinkBack);
    }

    public AbstractPersistentWriteableList(Class<E> newListType, PropertiedObject.Property newLinkBack, boolean collapse) {
        super(newListType, collapse);
        this.linkBack(newLinkBack);
    }

    public AbstractPersistentWriteableList<E> tearDownLinkBack(boolean tearDown) {
        this.tearDownLinkBack = tearDown;
        return this;
    }

    public boolean hasTearDownLinkBack() {
        return this.tearDownLinkBack;
    }

    protected abstract void saveObject(E var1) throws Exception;

    protected abstract void prepareObjectForSave(E var1, SaveContext var2) throws Exception;

    protected abstract void deleteObject(E var1) throws Exception;

    @Override
    public PersistentWriteableList<E> clone() {
        AbstractPersistentWriteableList clone = (AbstractPersistentWriteableList)super.clone();
        clone.deleteSet = new HashSet(2);
        return clone;
    }

    @Override
    public void prepareForSave(SaveContext context) {
        try {
            Iterator iterator = this.getMainList().iterator();
            while (iterator.hasNext()) {
                this.prepareObjectForSave((PersistentObjectI)iterator.next(), context);
            }
            iterator = this.deleteSet.iterator();
            while (iterator.hasNext()) {
                this.prepareObjectForSave((PersistentObjectI)iterator.next(), context);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error preparing persistent list data for save", e);
        }
    }

    @Override
    public void saveChild() {
        try {
            Iterator<E> iterator = this.deleteSet.iterator();
            while (iterator.hasNext()) {
                this.deleteObject((PersistentObjectI)iterator.next());
            }
            this.deleteSet.clear();
            iterator = this.getMainList().iterator();
            while (iterator.hasNext()) {
                this.saveObject((PersistentObjectI)iterator.next());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving persistent list data", e);
        }
    }

    @Override
    public void deleteChild() {
        this.clear();
        this.saveChild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildChanged() {
        if (!this.deleteSet.isEmpty()) {
            return true;
        }
        AbstractPersistentWriteableList abstractPersistentWriteableList = this;
        synchronized (abstractPersistentWriteableList) {
            this.downloadData();
        }
        boolean changed = false;
        for (int i = this.getMainList().size() - 1; i >= 0 && !changed; --i) {
            Object element = this.getMainList().get(i);
            if (element instanceof SaveableChild) {
                SaveableChild child = (SaveableChild)element;
                changed = child.hasChildChanged();
                continue;
            }
            if (!(element instanceof Saveable)) continue;
            Saveable saveable = (Saveable)element;
            changed = saveable.hasChanged();
        }
        return changed;
    }

    protected void tearDownLinkBack(Object ownedByThisList) {
        if (this.hasLinkBack() && this.hasTearDownLinkBack()) {
            try {
                Field refField = FieldUtils.getField(this.getLinkBack().getOwner(), this.getLinkBack().getName());
                if (refField.getType().equals(Reference.class)) {
                    Reference ref = (Reference)refField.get(ownedByThisList);
                    ref.set(null);
                } else {
                    refField.set(ownedByThisList, null);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("List is incorrectly configured.  Could not tear down link back", e);
            }
        }
    }

    @Override
    public synchronized void collapseUnsafe() {
        super.collapseUnsafe();
        this.deleteSet = new HashSet(2);
    }

    @Override
    public synchronized List<E> getLocalObjects() {
        return new ArrayList(this.getMainList());
    }

    protected void setupLinkBack(Collection collection) {
        if (this.hasLinkBack()) {
            for (Object toSetup : collection) {
                this.setupLinkBack(toSetup);
            }
        }
    }

    @Override
    public synchronized E set(int index, E element) {
        this.downloadData();
        PersistentObjectI delete = (PersistentObjectI)this.getMainList().set(index, element);
        if (element != null && element != delete && !element.equals(delete)) {
            this.deleteSet.remove(element);
            this.addToDeleteSet(delete);
            this.setupLinkBack(element);
        }
        return (E)delete;
    }

    @Override
    public synchronized boolean add(E element) {
        boolean toReturn = this.getMainList().add(element);
        if (toReturn) {
            this.deleteSet.remove(element);
        }
        this.setupLinkBack(element);
        return toReturn;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> toAdd) {
        boolean toReturn = this.getMainList().addAll(toAdd);
        if (toReturn) {
            this.deleteSet.removeAll(toAdd);
            this.setupLinkBack(toAdd);
        }
        return toReturn;
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> toAdd) {
        this.downloadData();
        boolean toReturn = this.getMainList().addAll(index, toAdd);
        if (toReturn) {
            this.deleteSet.removeAll(toAdd);
            this.setupLinkBack(toAdd);
        }
        return toReturn;
    }

    @Override
    public synchronized void add(int index, E element) {
        this.downloadData();
        this.getMainList().add(index, element);
        this.deleteSet.remove(element);
        this.setupLinkBack(element);
    }

    @Override
    public synchronized E remove(int index) {
        this.downloadData();
        PersistentObjectI removed = (PersistentObjectI)this.getMainList().remove(index);
        if (removed != null) {
            this.addToDeleteSet(removed);
        }
        return (E)removed;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> toRemove) {
        boolean retValue = false;
        this.downloadData();
        for (Object obj : toRemove) {
            boolean removed = this.getMainList().remove(obj);
            if (!removed) continue;
            this.addToDeleteSet((PersistentObjectI)obj);
            retValue = true;
        }
        return retValue;
    }

    @Override
    public synchronized boolean remove(Object toRemove) {
        this.downloadData();
        boolean success = this.getMainList().remove(toRemove);
        if (success) {
            this.addToDeleteSet((PersistentObjectI)toRemove);
        }
        return success;
    }

    @Override
    public synchronized void clear() {
        this.downloadData();
        if (this.hasTearDownLinkBack()) {
            for (Object toRemove : this.getMainList()) {
                this.tearDownLinkBack(toRemove);
            }
        }
        this.addToDeleteSet((E)this.getMainList());
        this.getMainList().clear();
    }

    private void addToDeleteSet(Collection<? extends E> persistentObjs) {
        for (PersistentObjectI obj : persistentObjs) {
            this.addToDeleteSet(obj);
        }
    }

    private void addToDeleteSet(E obj) {
        if (obj.isPersistent()) {
            this.deleteSet.add(obj);
        }
        this.tearDownLinkBack(obj);
    }

    public Class<E> getObjectType() {
        return this.getType();
    }

    @Override
    public boolean isPersistent() {
        return PersistentWriteableList.Helper.isPersistent(this);
    }
}

