/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.list;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.InitializeSql;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.SuperSaveable;
import au.com.ordermate.persistence.list.AbstractPersistentWriteableList;
import au.com.ordermate.sql.SQL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ManyToManyList<E extends PersistentObjectI & SuperSaveable>
extends AbstractPersistentWriteableList<E>
implements InitializeSql {
    private String orderByCondition = null;
    private Class ownerType;
    private String linkTable;
    private boolean saveChildren = false;
    private boolean useSystemState = false;
    private List<E> newlyAdded = new ArrayList();
    private transient String deleteSql;
    private transient String saveSql;
    private transient String selectSql;
    private String ownerTableLink;
    private String listTypeTableLink;

    public ManyToManyList(Class newOwnerType, Class<E> listType, String newLinkTable) {
        super(listType);
        this.ownerType = newOwnerType;
        this.linkTable = newLinkTable;
    }

    public ManyToManyList(Class newOwnerType, String ownerField, Class<E> listType, String listField, String newLinkTable) {
        super(listType);
        this.ownerType = newOwnerType;
        this.linkTable = newLinkTable;
        this.ownerTableLink = ownerField;
        this.listTypeTableLink = listField;
    }

    public ManyToManyList<E> orderBy(String orderByCol) {
        this.orderByCondition = orderByCol;
        return this;
    }

    public ManyToManyList<E> saveChildren(boolean saveKids) {
        this.saveChildren = saveKids;
        return this;
    }

    public ManyToManyList<E> useSystemState(boolean systemState) {
        this.useSystemState = systemState;
        if (this.useSystemState) {
            this.tearDownLinkBack(false);
        }
        return this;
    }

    @Override
    public ManyToManyList<E> clone() {
        ManyToManyList clone = (ManyToManyList)super.clone();
        clone.newlyAdded = new ArrayList();
        return clone;
    }

    public boolean hasSaveChildren() {
        return this.saveChildren;
    }

    public String getLinkTable() {
        return this.linkTable;
    }

    @Override
    public void initSQL() throws Exception {
        if (this.ownerTableLink == null) {
            this.ownerTableLink = "FK_" + PersistenceManager.getPersistenceMetaData().getClassTable(this.ownerType);
        }
        if (this.listTypeTableLink == null) {
            this.listTypeTableLink = "FK_" + PersistenceManager.getPersistenceMetaData().getClassTable(this.getType());
        }
        String listTypeTable = PersistenceManager.getPersistenceMetaData().getClassTable(this.getType());
        this.deleteSql = this.useSystemState ? "UPDATE " + this.linkTable + " SET system_state = 'DELETED' WHERE " + this.ownerTableLink + " = ? AND " + this.listTypeTableLink + " = ?" : "DELETE FROM " + this.linkTable + " WHERE " + this.ownerTableLink + " = ? AND " + this.listTypeTableLink + " = ?";
        this.saveSql = SQL.insert(this.linkTable, new String[]{this.ownerTableLink, this.listTypeTableLink});
        String listTypeID = PersistenceManager.getPersistenceMetaData().getPropertyColumn(new PropertiedObject.Property(this.getType(), PersistentObject.Properties.ID));
        this.selectSql = SQL.select(new String[]{listTypeTable + ".*"}, this.linkTable + ", " + listTypeTable, new String[]{this.linkTable + "." + this.ownerTableLink + " = ? ", this.linkTable + "." + this.listTypeTableLink + " = " + listTypeTable + "." + listTypeID});
        if (this.useSystemState) {
            this.selectSql = this.selectSql + " AND " + this.linkTable + ".system_state = 'ACTIVE'";
        }
        if (this.orderByCondition != null) {
            this.selectSql = this.selectSql + " ORDER BY " + this.orderByCondition;
        }
    }

    @Override
    protected void deleteObject(E toDelete) throws Exception {
        if (!(toDelete instanceof PersistentObject)) {
            throw new IllegalStateException("ManyToManyList must contain persistent objects, but found a " + toDelete.getClass());
        }
        if (this.deleteSql == null) {
            this.initSQL();
        }
        Long deleteID = toDelete.getID();
        PersistenceManager.getPersistenceDelegate().executeUpdate(this.deleteSql, new Object[]{this.getOwner().getID(), deleteID});
        if (this.hasSaveChildren()) {
            if (!(toDelete instanceof Saveable) || !(toDelete instanceof SaveableChild)) {
                throw new IllegalStateException("ManyToManyList must contain Saveable objects, but found a " + toDelete.getClass());
            }
            if (toDelete instanceof Saveable) {
                ((Saveable)toDelete).delete();
            } else {
                ((SaveableChild)toDelete).deleteChild();
            }
        }
    }

    @Override
    protected void prepareObjectForSave(E save, SaveContext context) throws Exception {
        if (!(save instanceof Saveable) || !(save instanceof SaveableChild)) {
            throw new IllegalStateException("ManyToManyList must contain Saveable objects, but found a " + save.getClass());
        }
        ((SaveableChild)save).prepareForSave(context);
    }

    @Override
    protected void saveObject(E save) throws Exception {
        if (!(save instanceof PersistentObject)) {
            throw new IllegalStateException("ManyToManyList must contain persistent objects, but found a " + save.getClass());
        }
        if (this.saveSql == null) {
            this.initSQL();
        }
        Long saveID = save.getID();
        PersistenceManager.getPersistenceDelegate().executeUpdate(this.saveSql, new Object[]{this.getOwner().getID(), saveID});
    }

    private void saveElement(E save) {
        if (!(save instanceof Saveable) || !(save instanceof SaveableChild)) {
            throw new IllegalStateException("ManyToManyList must contain Saveable objects, but found a " + save.getClass());
        }
        if (save instanceof Saveable) {
            ((Saveable)save).save();
        } else {
            ((SaveableChild)save).saveChild();
        }
    }

    @Override
    protected Collection<E> resolve() throws Exception {
        if (this.selectSql == null) {
            this.initSQL();
        }
        return PersistenceManager.getObjectList(this.getType(), this.selectSql, new Object[]{this.getID()});
    }

    @Override
    public void saveChild() {
        try {
            Iterator iterator = this.deleteSet.iterator();
            while (iterator.hasNext()) {
                this.deleteObject((PersistentObjectI)iterator.next());
            }
            this.deleteSet.clear();
            iterator = this.newlyAdded.iterator();
            while (iterator.hasNext()) {
                this.saveObject((PersistentObjectI)iterator.next());
            }
            this.newlyAdded.clear();
            if (this.hasSaveChildren()) {
                iterator = this.getMainList().iterator();
                while (iterator.hasNext()) {
                    this.saveElement((PersistentObjectI)iterator.next());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving persistent list data", e);
        }
    }

    @Override
    public boolean equals(Object other) {
        OrderMateLog.LOG.warn("Calling equals on manyToManyList, semantics have changed", (Throwable)new Exception());
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean add(E element) {
        this.newlyAdded.add(element);
        boolean retVal = this.getMainList().add(element);
        this.setupLinkBack(element);
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends E> toAdd) {
        this.newlyAdded.addAll(toAdd);
        boolean retVal = this.getMainList().addAll(toAdd);
        this.setupLinkBack(toAdd);
        return retVal;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> toAdd) {
        this.newlyAdded.addAll(toAdd);
        boolean retVal = this.getMainList().addAll(index, toAdd);
        this.setupLinkBack(toAdd);
        return retVal;
    }

    @Override
    public void add(int index, E element) {
        this.newlyAdded.add(element);
        this.getMainList().add(index, element);
        this.setupLinkBack(element);
    }

    @Override
    public E remove(int index) {
        Object removed = super.remove(index);
        this.newlyAdded.remove(removed);
        return (E)removed;
    }

    @Override
    public boolean remove(Object toRemove) {
        boolean success = super.remove(toRemove);
        if (success) {
            this.newlyAdded.remove(toRemove);
        }
        return success;
    }

    @Override
    public boolean removeAll(Collection<?> toRemove) {
        boolean retValue = super.removeAll(toRemove);
        this.newlyAdded.removeAll(toRemove);
        return retValue;
    }

    @Override
    public void clear() {
        super.clear();
        this.newlyAdded.clear();
    }
}

