/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.list;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.AbstractPersistentList;
import au.com.ordermate.persistence.InitializeSql;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class QueryList<E extends PersistentObjectI>
extends AbstractPersistentList<E>
implements InitializeSql {
    private String sql;
    private ObjectQuery query;
    private boolean resolvingPersistentObject;
    private boolean needsOwnerParam;
    private boolean setup;

    public static <E extends PersistentObjectI> PersistentList<E> createQueryList(Class<E> newListType, ObjectQuery newQuery) {
        return new QueryList<E>(newListType, newQuery);
    }

    public static <E extends PersistentObjectI> PersistentList<E> createQueryList(Class<E> newListType, String newQuery) {
        return new QueryList<E>(newListType, newQuery);
    }

    private QueryList(Class<E> newListType, ObjectQuery newQuery) {
        super(newListType);
        this.query = newQuery;
    }

    private QueryList(Class<E> newListType, String newSql) {
        super(newListType);
        this.sql = newSql;
    }

    @Override
    public void initSQL() throws Exception {
        if (this.sql == null) {
            this.sql = this.query.toString();
        }
    }

    @Override
    protected Collection<E> resolve() throws Exception {
        if (!this.setup) {
            if (this.sql == null) {
                this.initSQL();
            }
            if (PersistentObject.class.isAssignableFrom(this.getType())) {
                this.resolvingPersistentObject = true;
            }
            int numParams = StringUtils.countMatches(this.sql, "?");
            if (this.getOwner() != null && numParams == 1) {
                this.needsOwnerParam = true;
            }
            this.setup = true;
        }
        Object[] params = this.needsOwnerParam ? new Object[]{this.getOwner().getID()} : new Object[]{};
        if (this.resolvingPersistentObject) {
            return PersistenceManager.getObjectList(this.getType(), this.sql, params);
        }
        throw new IllegalStateException("Resolving object not assignable from persistentObject");
    }

    public synchronized List getList() {
        return Collections.unmodifiableList(new ArrayList(this.getMainList()));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

