/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.propertyaccessor;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.ChainPropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.ListChainPropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessorVendor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;

public abstract class AbstractPropertyAccessorVendor
implements PropertyAccessorVendor {
    protected Map<Class, List<PropertiedObject.Property>> properties = new HashMap<Class, List<PropertiedObject.Property>>();

    @Override
    public List<PropertiedObject.Property> getProperties(Class clazz) {
        if (this.properties.get(clazz) != null) {
            return this.properties.get(clazz);
        }
        ArrayList<PropertiedObject.Property> props = new ArrayList<PropertiedObject.Property>();
        if (PropertiedObject.class.isAssignableFrom(clazz)) {
            PropertiedObject.Property[] allProps = null;
            try {
                PropertiedObject.Props propsClazz = (PropertiedObject.Props)clazz.getField("Properties").get(null);
                allProps = propsClazz.asArray();
                for (PropertiedObject.Property prop : allProps) {
                    if (!this.isAccessible(prop)) continue;
                    props.add(prop);
                }
                for (Field field : propsClazz.getClass().getFields()) {
                    if (!PersistentObject.DerivedProperty.class.isAssignableFrom(field.getType())) continue;
                    props.add((PropertiedObject.Property)field.get(propsClazz));
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot retrieve properties for class " + clazz, (Throwable)ex);
            }
        }
        this.properties.put(clazz, props);
        return props;
    }

    protected void clearProperties() {
        this.properties.clear();
    }

    protected abstract boolean isAccessible(PropertiedObject.Property var1);

    @Override
    public PropertyAccessor vendAccessor(PropertiedObject.Property prop) {
        if (this.isAccessible(prop)) {
            PropertyAccessor[] path = this.getPathTo(prop.getOwner());
            if (path == null || path.length == 0) {
                return prop;
            }
            boolean list = false;
            block0: for (PropertyAccessor nextProp : path) {
                if (list) break;
                for (PropertiedObject.Property step : nextProp.getPropertyChain()) {
                    if (!step.getProperty().isList()) continue;
                    list = true;
                    continue block0;
                }
            }
            PropertyAccessor[] newPath = new PropertyAccessor[path.length + 1];
            System.arraycopy(path, 0, newPath, 0, path.length);
            newPath[path.length] = prop;
            if (list) {
                return new ListChainPropertyAccessor(newPath);
            }
            return new ChainPropertyAccessor(newPath);
        }
        return prop;
    }

    protected abstract PropertyAccessor[] getPathTo(Class var1);

    @Override
    public String toString(PropertyAccessor accessor) {
        StringBuilder SB = new StringBuilder(accessor.getProperty().getOwner().getCanonicalName());
        SB.append("#").append(accessor.getProperty().getName());
        return SB.toString();
    }

    @Override
    public PropertyAccessor fromString(String accessorString) {
        if (accessorString == null) {
            return null;
        }
        String[] split = accessorString.split("#");
        if (split != null && split.length == 2) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(split[0]);
                PropertiedObject.Property prop = null;
                for (PropertiedObject.Property next : this.getProperties(clazz)) {
                    if (!split[1].equals(next.getName())) continue;
                    prop = next;
                    break;
                }
                if (prop != null) {
                    return this.vendAccessor(prop);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot resolve class from string " + accessorString, (Throwable)ex);
            }
        }
        return null;
    }
}

