/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.propertyaccessor;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.reflect.SyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class ChainPropertyAccessor
implements PropertyAccessor {
    protected final PropertyAccessor[] accessorArray;

    public ChainPropertyAccessor(PropertyAccessor ... props) {
        this.accessorArray = props;
    }

    public PropertiedObject.Property getProperty() {
        return this.accessorArray[this.accessorArray.length - 1].getProperty();
    }

    public Object resolveValue(Object baseObj) {
        try {
            return this.resolve(baseObj, this.accessorArray, 0);
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Error accessing property value ");
            msg.append(this.getProperty().getName()).append(" from ").append(baseObj).append(" using accessor list: ");
            for (int i = 0; i < this.accessorArray.length; ++i) {
                msg.append(this.accessorArray[i].getProperty().getName());
                if (i >= this.accessorArray.length - 1) continue;
                msg.append(", ");
            }
            throw new RuntimeException(msg.toString(), e);
        }
    }

    @Override
    public Object resolveObj(Object baseObj, int idx) {
        Object resolvedObj = baseObj;
        for (int i = idx; i < this.accessorArray.length; ++i) {
            resolvedObj = this.accessorArray[i].resolveValue(resolvedObj);
        }
        return resolvedObj;
    }

    private Object resolve(Object toAccess, PropertyAccessor[] currentAccessors, int index) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, SyntaxException {
        Object nextObj = currentAccessors[index].resolveValue(toAccess);
        if (index == currentAccessors.length - 1 || nextObj == null) {
            return nextObj;
        }
        return this.resolve(nextObj, currentAccessors, index + 1);
    }

    @Override
    public PropertiedObject.Property getBaseProperty() {
        return this.accessorArray[0].getBaseProperty();
    }

    public String toString() {
        return "Chain:" + Arrays.toString(this.accessorArray);
    }

    @Override
    public PropertiedObject.Property[] getPropertyChain() {
        PropertiedObject.Property[] newProps = new PropertiedObject.Property[this.accessorArray.length];
        System.arraycopy(this.accessorArray, 0, newProps, 0, this.accessorArray.length);
        return newProps;
    }
}

