/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.propertyaccessor;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ListChainPropertyAccessor
implements PropertyAccessor {
    private final PropertyAccessor[] propArray;

    public ListChainPropertyAccessor(PropertyAccessor ... arrayList) {
        this.propArray = arrayList;
    }

    public PropertiedObject.Property getProperty() {
        return this.propArray[this.propArray.length - 1].getProperty();
    }

    public Object resolveValue(Object baseObj) {
        if (baseObj == null) {
            return null;
        }
        try {
            HashSet set = new HashSet();
            this.resolve(baseObj, 0, set);
            if (set.isEmpty()) {
                return null;
            }
            if (set.size() == 1) {
                return set.iterator().next();
            }
            return set;
        }
        catch (Exception e) {
            String msg = "Error accessing property value " + this.getProperty().getName() + " from " + baseObj + " using accessor list: ";
            for (int i = 0; i < this.propArray.length; ++i) {
                msg = msg + this.propArray[i].getProperty().getName();
                if (i >= this.propArray.length - 1) continue;
                msg = msg + ", ";
            }
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public Object resolveObj(Object baseObj, int idx) {
        Object resolvedObj = baseObj;
        for (int i = idx; i < this.propArray.length; ++i) {
            if ((resolvedObj = this.propArray[i].resolveValue(resolvedObj)) != null) continue;
            return null;
        }
        return resolvedObj;
    }

    private void resolve(Object toAccess, int propertyIndex, Collection toAddTo) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        if (toAccess == null) {
            return;
        }
        if (propertyIndex == this.propArray.length) {
            if (toAccess instanceof List) {
                this.resolveListObject((List)toAccess, propertyIndex, toAddTo);
            } else {
                toAddTo.add(toAccess);
            }
        } else if (toAccess instanceof List) {
            this.resolveListObject((List)toAccess, propertyIndex, toAddTo);
        } else {
            Object nextObj = this.propArray[propertyIndex].resolveValue(toAccess);
            this.resolve(nextObj, propertyIndex + 1, toAddTo);
        }
    }

    private void resolveListObject(List toAccess, int propertyIndex, Collection toAddTo) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Iterator it = toAccess.iterator();
        while (it.hasNext()) {
            this.resolve(it.next(), propertyIndex, toAddTo);
        }
    }

    @Override
    public PropertiedObject.Property getBaseProperty() {
        return this.propArray[0].getBaseProperty();
    }

    @Override
    public PropertiedObject.Property[] getPropertyChain() {
        PropertiedObject.Property[] newProps = new PropertiedObject.Property[this.propArray.length];
        System.arraycopy(this.propArray, 0, newProps, 0, this.propArray.length);
        return newProps;
    }
}

