/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.reference;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.serialization.SerializationHelper;
import au.com.ordermate.reflect.ReflectUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.locks.ReentrantLock;
import ordermate.database.DatabaseObject;

public abstract class AbstractReference<T extends PersistentObjectI>
implements Reference<T> {
    protected Long objectID;
    protected T reference;
    private PersistentObject owner;
    private boolean collapseOnSerialize;
    private transient Class<T> type;
    private final ReentrantLock lock = new ReentrantLock();

    public AbstractReference(Class<T> refType) {
        this.type = refType;
    }

    public AbstractReference<T> collapseOnSerialize(boolean collapse) {
        this.collapseOnSerialize = collapse;
        return this;
    }

    @Override
    public boolean belongsToOwner() {
        return true;
    }

    @Override
    public boolean isNull() {
        return this.reference == null && this.objectID == null;
    }

    @Override
    public final Class<T> getType() {
        return this.type;
    }

    public final Class<T> getObjectType() {
        return this.getType();
    }

    @Override
    public T get() {
        if (!this.isExpanded()) {
            try {
                T newReference = this.resolve();
                if (newReference != null && !this.type.isAssignableFrom(newReference.getClass())) {
                    throw new IllegalArgumentException("This reference can only store objects of " + this.type + " or its subclasses, insted got : " + newReference.getClass());
                }
                if (this.objectID != null && newReference == null) {
                    String msg = "Could not resolve Object ID : " + this.objectID + " of class:" + this.getType() + (this.owner != null ? " for owner :" + this.owner.getID() + " of class " + this.owner.getObjectType() : " without owner.");
                    OrderMateLog.LOG.warn(msg);
                }
                this.reference = newReference;
                this.objectID = null;
            }
            catch (Exception e) {
                throw new RuntimeException("Error downloading persistent reference data", e);
            }
        }
        return this.reference;
    }

    @Override
    public boolean isExpanded() {
        return this.objectID == null;
    }

    @Override
    public void set(T value) {
        if (value != null && !this.type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("This reference can only store objects of " + this.type + " or its subclasses");
        }
        this.objectID = null;
        this.reference = value;
    }

    @Override
    public void setObjectID(Long newObjectID) {
        this.objectID = newObjectID;
        this.reference = null;
    }

    @Override
    public final Long getObjectID() {
        if (!this.isExpanded()) {
            return this.objectID;
        }
        if (this.reference != null) {
            if (this.reference instanceof PersistentObject) {
                return this.reference.getID();
            }
            if (this.reference instanceof DatabaseObject) {
                DatabaseObject databaseObject = (DatabaseObject)this.reference;
                if (databaseObject.getID() > 0L) {
                    return databaseObject.getID();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public final Long getID() {
        return this.getObjectID();
    }

    @Override
    public final boolean isPersistent() {
        return this.getObjectID() != null;
    }

    @Override
    public final void setOwner(PersistentObject newOwner) {
        this.owner = newOwner;
    }

    protected PersistentObject getOwner() {
        return this.owner;
    }

    protected abstract T resolve() throws Exception;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            OrderMateLog.LOG.error("Reference clone not supported.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveChild() {
        if (!Saveable.class.isAssignableFrom(this.getType()) && !SaveableChild.class.isAssignableFrom(this.getType())) {
            throw new UnsupportedOperationException("Cannot call save unless the object being referenced implements Saveable or SaveableChild");
        }
        if (this.isExpanded() && this.reference != null) {
            if (this.reference instanceof Saveable) {
                ((Saveable)this.reference).save();
            } else if (this.reference instanceof SaveableChild) {
                ((SaveableChild)this.reference).saveChild();
            }
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
        if (!Saveable.class.isAssignableFrom(this.getType()) && !SaveableChild.class.isAssignableFrom(this.getType())) {
            throw new UnsupportedOperationException("Cannot call prepareForSave unless the object being referenced implements Saveable or SaveableChild");
        }
        if (this.isExpanded() && this.reference != null) {
            if (this.reference instanceof Saveable) {
                ((Saveable)this.reference).prepareForSave(context);
            } else if (this.reference instanceof SaveableChild) {
                ((SaveableChild)this.reference).prepareForSave(context);
            }
        }
    }

    @Override
    public void deleteChild() {
        if (!Saveable.class.isAssignableFrom(this.getType()) && !SaveableChild.class.isAssignableFrom(this.getType())) {
            throw new UnsupportedOperationException("Cannot call delete unless the object being referenced implements Saveable or SaveableChild");
        }
        this.get();
        if (this.reference != null) {
            if (this.reference instanceof Saveable) {
                ((Saveable)this.reference).delete();
            } else if (this.reference instanceof SaveableChild) {
                ((SaveableChild)this.reference).deleteChild();
            }
        }
    }

    @Override
    public boolean hasChildChanged() {
        if (!Saveable.class.isAssignableFrom(this.getType()) && !SaveableChild.class.isAssignableFrom(this.getType())) {
            throw new UnsupportedOperationException("Cannot call hasChanged unless the object being referenced implements Saveable or SaveableChild");
        }
        if (this.isExpanded() && this.reference != null) {
            if (this.reference instanceof Saveable) {
                return ((Saveable)this.reference).hasChanged();
            }
            if (this.reference instanceof SaveableChild) {
                return ((SaveableChild)this.reference).hasChildChanged();
            }
            return false;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        Object tempReference = null;
        if (this.collapseOnSerialize && this.isExpanded()) {
            tempReference = this.reference;
            this.collapse();
        }
        stream.defaultWriteObject();
        SerializationHelper.writeClass(this.type, stream);
        if (tempReference != null) {
            this.reference = tempReference;
            this.objectID = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.type = SerializationHelper.readClass(in);
    }

    @Override
    public void collapse() {
        this.lock.lock();
        try {
            if (this.isExpanded() && this.reference != null) {
                T persistentRef;
                if (this.reference instanceof PersistentObject && !(persistentRef = this.reference).isPersistent()) {
                    throw new IllegalStateException("Cannot collapse reference, as referent is not persistent and cannot be reloaded from DB: " + persistentRef + " of class " + persistentRef.getClass());
                }
                this.objectID = this.getObjectID();
                this.reference = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        String str = this.objectID != null ? ReflectUtils.getShortClassName(this.type) + " #" + this.objectID : (this.reference != null ? this.reference.toString() : "null");
        return "Ref=[" + str + "]";
    }

    public synchronized Object getReference() {
        return this.reference;
    }
}

