/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.reference;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.reference.AbstractReference;
import au.com.ordermate.util.StringUtils;

public class QueryReference<T extends PersistentObjectI>
extends AbstractReference<T> {
    private final ObjectQuery query;
    private String sql;
    private boolean resolvingPersistentObject;
    private boolean expanded;
    private boolean needsOwnerParam;

    public QueryReference(Class<T> refType, ObjectQuery newQuery) {
        super(refType);
        if (newQuery == null) {
            throw new NullPointerException("New query should not be null");
        }
        this.query = newQuery;
    }

    @Override
    public void initSQL() throws Exception {
        int numParams;
        this.sql = this.query.toString();
        if (PersistentObjectI.class.isAssignableFrom(this.getType())) {
            this.resolvingPersistentObject = true;
        }
        if ((numParams = StringUtils.countMatches(this.sql, "?")) == 1) {
            this.needsOwnerParam = true;
        }
    }

    @Override
    protected T resolve() throws Exception {
        if (this.sql == null) {
            this.initSQL();
        }
        Object[] params = this.needsOwnerParam ? new Object[]{this.getOwner().getID()} : new Object[]{};
        if (this.resolvingPersistentObject) {
            Object toReturn = PersistenceManager.getObject(this.getType(), this.sql, params);
            this.expanded = true;
            return toReturn;
        }
        throw new IllegalStateException("Resolving object not assignable from persistent object " + this.getType());
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void collapse() {
        super.collapse();
        this.expanded = false;
    }

    @Override
    public boolean belongsToOwner() {
        return false;
    }

    public void clearCache() {
        this.expanded = false;
        this.reference = null;
    }
}

