/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.reference;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.reference.AbstractReference;

public class SingletonReference<T extends PersistentObjectI>
extends AbstractReference<T> {
    public SingletonReference(Class<T> refType) {
        super(refType);
    }

    @Override
    protected T resolve() throws Exception {
        Object instance = PersistenceManager.getInstance().getSingletonObject(this.getType());
        assert (instance != null) : "Singleton " + this.getType() + " not found.";
        return instance;
    }

    @Override
    public void collapse() {
        this.reference = null;
    }

    @Override
    public boolean isExpanded() {
        return this.reference != null;
    }

    @Override
    public boolean belongsToOwner() {
        return false;
    }

    @Override
    public void initSQL() {
    }
}

