/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.synchronisation;

import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.synchronisation.Converter;
import au.com.ordermate.persistence.synchronisation.PersistentEnumConverter;
import au.com.ordermate.persistence.synchronisation.PriceConverter;
import au.com.ordermate.persistence.synchronisation.SalesQuantityConverter;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import au.com.ordermate.persistence.synchronisation.TriggerActivationStrategyConverter;
import au.com.ordermate.reflect.FieldUtils;
import au.com.ordermate.units.UnitScales;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Table;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.gui.TerminalTypes;
import ordermate.database.hardware.ButtonWidth;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.PhysicalPrintDeviceType;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.hardware.physical.kts.KTSMilestoneAction;
import ordermate.database.hardware.physical.kts.KTSMilestoneInclude;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.inventory.combos.ComboStrategy;
import ordermate.database.inventory.coupon.CouponActivationStrategy;
import ordermate.database.inventory.coupon.PeriodUnit;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.kiosk.KioskType;
import ordermate.database.kiosk.pages.item.KioskPageItemType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Gender;
import ordermate.database.users.LockingUserReference;
import ordermate.hom.synchronisation.IdTranslator;

public abstract class AbstractPersistentObjectCreator {
    private static final Converter[] converters = new Converter[]{new PriceConverter(), new SalesQuantityConverter(), new TriggerActivationStrategyConverter(), new PersistentEnumConverter(AccountType.class, AccountType.getRegister()), new PersistentEnumConverter(AccountState.class, AccountState.getRegister()), new PersistentEnumConverter(Account.ReceiptPrintState.class, Account.ReceiptPrintState.getRegister()), new PersistentEnumConverter(Account.AccountClassType.class, Account.AccountClassType.getRegister()), new PersistentEnumConverter(PriceAdjustmentLevel.class, PriceAdjustmentLevel.getRegister()), new PersistentEnumConverter(PriceAdjustmentDirection.class, PriceAdjustmentDirection.getRegister()), new PersistentEnumConverter(PriceAdjustmentType.class, PriceAdjustmentType.getRegister()), new PersistentEnumConverter(PriceAdjustmentUnit.class, PriceAdjustmentUnit.getRegister()), new PersistentEnumConverter(AbstractReconciliationEntry.RecEntryType.class, AbstractReconciliationEntry.RecEntryType.register), new PersistentEnumConverter(SystemState.class, SystemState.register), new PersistentEnumConverter(EftposType.class, EftposType.getRegister()), new PersistentEnumConverter(EftposStatus.class, EftposStatus.register), new PersistentEnumConverter(AbstractTrigger.Types.class, AbstractTrigger.Types.register), new PersistentEnumConverter(KTSDocketState.class, KTSDocketState.getRegister()), new PersistentEnumConverter(ButtonWidth.class, ButtonWidth.register), new PersistentEnumConverter(InventoryWeightUnit.class, InventoryWeightUnit.register), new PersistentEnumConverter(AbstractDocket.DocketClassType.class, AbstractDocket.DocketClassType.getRegister()), new PersistentEnumConverter(KTSMilestoneInclude.class, KTSMilestoneInclude.getRegister()), new PersistentEnumConverter(KTSMilestoneAction.class, KTSMilestoneAction.getRegister()), new PersistentEnumConverter(DocketTemplate.DocketType.class, DocketTemplate.DocketType.register), new PersistentEnumConverter(PhysicalPrintDeviceType.class, PhysicalPrintDeviceType.getRegister()), new PersistentEnumConverter(TerminalTypes.class, TerminalTypes.getRegister()), new PersistentEnumConverter(Gender.class, Gender.getRegister()), new PersistentEnumConverter(KioskPageItemType.class, KioskPageItemType.getRegister()), new PersistentEnumConverter(KioskType.class, KioskType.getRegister()), new PersistentEnumConverter(CouponActivationStrategy.class, CouponActivationStrategy.register), new PersistentEnumConverter(PeriodUnit.class, PeriodUnit.register), new PersistentEnumConverter(ComboStrategy.class, ComboStrategy.getRegister()), new PersistentEnumConverter(UnitScales.class, PersistentEnumeration.buildRegister(UnitScales.values()))};
    private final Map<Class, Converter> converterMap = new HashMap<Class, Converter>();
    protected final IdTranslator translator;
    private Map<Class, Boolean> tableAnnotationMap = new HashMap<Class, Boolean>();

    public AbstractPersistentObjectCreator() {
        this(null);
    }

    public AbstractPersistentObjectCreator(IdTranslator theTranslator) {
        this.translator = theTranslator;
        for (Converter converter : converters) {
            this.converterMap.put(converter.getType(), converter);
        }
    }

    public void setConverter(Class clazz, Converter converter) {
        if (converter != null) {
            this.converterMap.put(clazz, converter);
        } else {
            this.converterMap.remove(clazz);
        }
    }

    protected abstract <T extends PersistentObject> T findObject(Class<T> var1, long var2);

    protected void objectCreated(PersistentObject obj, long id) {
    }

    public PersistentObject createFromSnapShotContent(SynchronisationSnapshot snapshot) {
        Class objectType = this.getClassFromSnapshotContent(snapshot);
        if (objectType == null) {
            AbstractPersistentObjectCreator.getLogger().log(Level.SEVERE, "Could not get class for snapshot " + snapshot);
            return null;
        }
        PersistentObject persistentObj = null;
        try {
            persistentObj = this.retrieveObject(objectType, snapshot);
            if (persistentObj == null) {
                persistentObj = this.createObject(objectType);
                if (persistentObj == null) {
                    return null;
                }
                Number value = (Number)snapshot.get("ID");
                this.objectCreated(persistentObj, value == null ? -1L : value.longValue());
            }
        }
        catch (Exception e) {
            AbstractPersistentObjectCreator.getLogger().log(Level.WARNING, "Could not instantiate " + objectType + ".", e);
            return null;
        }
        for (String propertyName : snapshot.getPropertyNames()) {
            Object value = snapshot.get(propertyName);
            this.setPropertyValue(value, persistentObj, propertyName);
        }
        return persistentObj;
    }

    protected PersistentObject createObject(Class<? extends PersistentObject> objectType) throws InstantiationException, IllegalAccessException {
        return objectType.newInstance();
    }

    protected PersistentObject retrieveObject(Class objectType, SynchronisationSnapshot snapshot) {
        Number value = (Number)snapshot.get("ID");
        if (value != null && value.longValue() > 0L) {
            if (this.translator != null) {
                value = this.translator.convertToLocalId(value);
                snapshot.put("ID", value);
            }
            return this.findObject(objectType, value.longValue());
        }
        return null;
    }

    private void setPropertyValue(Object value, PersistentObject persistentObj, String propertyName) {
        block15: {
            try {
                Field field = PersistentObject.getField(persistentObj.getClass(), propertyName);
                if (field == null) {
                    String msg = "Could not set the value " + value + " of type " + value.getClass() + " due to missing property " + propertyName + " of " + persistentObj.getClass();
                    AbstractPersistentObjectCreator.getLogger().log(Level.FINE, msg);
                    return;
                }
                Class<Reference> fieldType = (field = this.swapField(field)).getType();
                if (!this.converterMap.containsKey(fieldType) && (fieldType.isAssignableFrom(Reference.class) || fieldType.equals(LockingUserReference.class))) {
                    field.setAccessible(true);
                    Reference ref = (Reference)field.get(persistentObj);
                    if (ref == null) {
                        if (persistentObj instanceof PersistentSummaryObject) {
                            return;
                        }
                        throw new IllegalStateException("The reference object is null");
                    }
                    if (!this.checkTypeHasTableAnnotation(ref.getType())) {
                        return;
                    }
                    Class refType = field.getType();
                    if (fieldType.isAssignableFrom(Reference.class)) {
                        try {
                            Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                            if (types != null && types.length > 0) {
                                refType = (Class)types[0];
                            }
                        }
                        catch (Exception ex) {
                            OrderMate.LOG.warn("Couldn't get parameterized types for reference.");
                        }
                    }
                    Long theValue = null;
                    if (refType != null && this.converterMap.containsKey(refType)) {
                        ref.set((PersistentObjectI)this.converterMap.get(refType).convert(value, AbstractPersistentObjectCreator.getProperty(propertyName, persistentObj.getClass()), persistentObj));
                    } else {
                        theValue = (Long)value;
                        if (this.translator != null) {
                            theValue = this.translator.convertToLocalId((Long)value);
                        }
                        if (theValue != null && theValue == 0L) {
                            OrderMate.LOG.warn("Setting foreign key reference to null, zero is not allowed." + persistentObj.getClass() + " id:" + persistentObj.getID() + " field:" + field.getName());
                            theValue = null;
                        }
                        this.loadReference(ref, theValue);
                    }
                    break block15;
                }
                Object convertedValue = this.convert(persistentObj, field.getName(), fieldType, value);
                FieldUtils.setValue(persistentObj, field.getName(), convertedValue);
            }
            catch (Exception e) {
                this.handlePropertyException(e, value, persistentObj, propertyName);
            }
        }
    }

    protected Field swapField(Field field) {
        return field;
    }

    protected void loadReference(Reference ref, Long idValue) {
        ref.setObjectID(idValue);
    }

    protected void handlePropertyException(Exception ex, Object value, PersistentObject persistentObj, String propertyName) {
        String msg = "Error trying to set the value " + value + (value != null ? " of type " + value.getClass() : "") + " for property " + propertyName + " of " + persistentObj.getClass() + ":" + ex;
        AbstractPersistentObjectCreator.getLogger().log(Level.WARNING, msg, ex);
    }

    public Class getClassFromSnapshotContent(SynchronisationSnapshot snapshot) {
        if (snapshot == null) {
            throw new IllegalArgumentException("Snap shot should not be null");
        }
        String className = snapshot.getObjectType();
        Class<?> objectType = null;
        try {
            objectType = Class.forName(className);
        }
        catch (ClassNotFoundException cnf) {
            AbstractPersistentObjectCreator.getLogger().log(Level.WARNING, "The class " + className + " does not exist.", cnf);
            return null;
        }
        return objectType;
    }

    public static PropertiedObject.Property getProperty(String propertyName, Class persistentClass) {
        PropertiedObject.Property retValue = null;
        try {
            PersistentObject.Props propsInstance = (PersistentObject.Props)persistentClass.getDeclaredField("Properties").get(null);
            for (PropertiedObject.Property prop : propsInstance) {
                if (!prop.getName().equals(propertyName)) continue;
                retValue = prop;
                break;
            }
        }
        catch (Exception e) {
            AbstractPersistentObjectCreator.getLogger().log(Level.WARNING, "Cannot extract the property " + propertyName, e);
        }
        return retValue;
    }

    public static Logger getLogger() {
        return Logger.getLogger(AbstractPersistentObjectCreator.class.getName());
    }

    private Object convert(PersistentObject persistentObj, String propertyName, Class propType, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        Object converted = value;
        Converter converter = this.converterMap.get(propType);
        if (converter == null && propType.isEnum()) {
            OrderMate.LOG.warn("Couldn't find converter for enum, creating a new one:" + propType);
            Object[] values = (Object[])propType.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            this.converterMap.put(propType, new PersistentEnumConverter(propType, PersistentEnumeration.buildRegister(values)));
            converter = this.converterMap.get(propType);
        }
        if (converter != null) {
            PropertiedObject.Property prop = AbstractPersistentObjectCreator.getProperty(propertyName, persistentObj.getClass());
            converted = converter.convert(value, prop, persistentObj);
        }
        return converted;
    }

    private boolean checkTypeHasTableAnnotation(Class clazz) {
        if (!this.tableAnnotationMap.containsKey(clazz)) {
            this.findAndInsertClassToAnnotationMap(clazz);
        }
        return this.tableAnnotationMap.get(clazz);
    }

    private void findAndInsertClassToAnnotationMap(Class clazz) {
        boolean foundAnnotation = false;
        Class classToInspect = clazz;
        do {
            if (classToInspect.getAnnotation(Table.class) == null) continue;
            foundAnnotation = true;
            break;
        } while ((classToInspect = classToInspect.getSuperclass()) != null && !classToInspect.equals(Object.class));
        this.tableAnnotationMap.put(clazz, foundAnnotation);
    }
}

