/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.synchronisation;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.PersistenceListener;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.persistence.synchronisation.PersistenceSyncInterceptor;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ordermate.OrderMate;

class InterceptorWorker {
    private final BlockingQueue<SnapshotOperation> workQueue = new ArrayBlockingQueue<SnapshotOperation>(10000);
    private ExecutorService service;
    private final PersistenceSyncInterceptor interceptor;
    private WorkerServiceLoop loop;

    public InterceptorWorker(PersistenceSyncInterceptor interceptor) {
        this.interceptor = interceptor;
        this.start();
    }

    private void start() {
        this.service = Executors.newSingleThreadExecutor();
        this.loop = new WorkerServiceLoop();
        this.service.submit(this.loop);
    }

    protected void stop() {
        if (this.loop != null) {
            this.loop.running = false;
        }
        this.service.shutdown();
    }

    private void notifyListeners(SnapshotOperation snapshotOp) {
        for (PersistenceListener listener : this.interceptor.getListeners()) {
            try {
                listener.objectChanged(snapshotOp.snapshot, snapshotOp.op);
            }
            catch (Exception e) {
                OrderMateLog.LOG.error("Cannot notify listener:", (Throwable)e);
            }
        }
    }

    public void put(PersistentObjectSnapshot<?> snapshot, PersistenceOperation op) {
        if (!this.loop.running) {
            OrderMate.LOG.warn("Cannot put snapshot into queue, this worker is not running. Attempting to restart.");
            this.stop();
            this.start();
        }
        this.workQueue.add(new SnapshotOperation(snapshot, op));
    }

    class WorkerServiceLoop
    implements Runnable {
        private volatile boolean running = true;

        WorkerServiceLoop() {
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    SnapshotOperation snapshotOp = (SnapshotOperation)InterceptorWorker.this.workQueue.take();
                    InterceptorWorker.this.notifyListeners(snapshotOp);
                }
                catch (InterruptedException ie) {
                    OrderMate.LOG.warn("Persistence interceptor worker thread shutting down from interruption", (Throwable)ie);
                    this.running = false;
                }
                catch (Throwable ex) {
                    OrderMate.LOG.error("Error in interceptor worker thread:", ex);
                }
            }
        }
    }

    static class SnapshotOperation {
        private final PersistentObjectSnapshot snapshot;
        private final PersistenceOperation op;

        public SnapshotOperation(PersistentObjectSnapshot<?> snapshot, PersistenceOperation op) {
            this.snapshot = snapshot;
            this.op = op;
        }
    }
}

