/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.synchronisation;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.UnsafePersistence;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.persistence.synchronisation.InterceptorWorker;
import au.com.ordermate.persistence.synchronisation.PersistenceListener;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.persistence.synchronisation.PersistenceWrapperAdapter;
import au.com.ordermate.persistence.synchronisation.PrePersistenceListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;

public class PersistenceSyncInterceptor
extends PersistenceWrapperAdapter {
    public static PersistenceSyncInterceptor instance;
    private final List<PersistenceListener> listeners = new ArrayList<PersistenceListener>();
    private List<PersistenceListener> externalListeners = new ArrayList<PersistenceListener>();
    private InterceptorWorker worker;
    private final List<PrePersistenceListener> prePersistListeners = new ArrayList<PrePersistenceListener>();

    public PersistenceSyncInterceptor(UnsafePersistence toWrap) {
        super(toWrap);
        this.worker = new InterceptorWorker(this);
        instance = this;
    }

    @Override
    public long saveOrUpdate(PersistentObjectSnapshot toSave) throws Exception {
        this.notifyPrePersist(toSave, PersistenceOperation.SAVE);
        Long oldId = toSave.getID();
        long toReturn = this.persistence.saveOrUpdate(toSave);
        this.insertId(toReturn, toSave);
        this.fireChange(toSave, oldId == null ? PersistenceOperation.SAVE : PersistenceOperation.UPDATE);
        return toReturn;
    }

    @Override
    public void update(PersistentObjectSnapshot toUpdate, PropertiedObject.Property[] properties) throws Exception {
        this.persistence.update(toUpdate, properties);
        this.notifyPrePersist(toUpdate, PersistenceOperation.UPDATE);
        this.fireChange(toUpdate, PersistenceOperation.UPDATE);
    }

    @Override
    public void delete(PersistentObjDescriptor toDelete) throws Exception {
        this.notifyPrePersist(toDelete, PersistenceOperation.DELETE);
        this.persistence.delete(toDelete);
        PersistentObjectSnapshot snapshot = new PersistentObjectSnapshot(toDelete.getObjectType(), 1);
        this.insertId(toDelete.getID(), snapshot);
        this.fireChange(snapshot, PersistenceOperation.DELETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPersistenceListener(PersistenceListener listener) {
        List<PersistenceListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.add(listener)) {
                ArrayList<PersistenceListener> newList = new ArrayList<PersistenceListener>(this.listeners);
                this.externalListeners = newList;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePersistenceListener(PersistenceListener listener) {
        List<PersistenceListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.remove(listener)) {
                ArrayList<PersistenceListener> newList = new ArrayList<PersistenceListener>(this.listeners);
                this.externalListeners = newList;
                return true;
            }
        }
        return false;
    }

    public void fireChange(PersistentObjectSnapshot snapshot, PersistenceOperation operation) {
        try {
            this.worker.put(snapshot, operation);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occurred attempt to put snapshot operation in work queue, Discarding operation, HO may no longer synchronised", (Throwable)ex);
        }
    }

    protected List<PersistenceListener> getListeners() {
        return this.externalListeners;
    }

    @Override
    public Map<String, ?> getPropertyMetadata(PropertiedObject.Property prop) throws Exception {
        return this.persistence.getPropertyMetadata(prop);
    }

    private void insertId(Long id, PersistentObjectSnapshot toSave) {
        toSave.add(PersistentObject.Properties.ID, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePrePersistListener(PrePersistenceListener prePersistListener) {
        List<PrePersistenceListener> list = this.prePersistListeners;
        synchronized (list) {
            return this.prePersistListeners.remove(prePersistListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPrePersistListener(PrePersistenceListener prePersistListener) {
        List<PrePersistenceListener> list = this.prePersistListeners;
        synchronized (list) {
            return this.prePersistListeners.add(prePersistListener);
        }
    }

    public void notifyPrePersist(PersistentObjectSnapshot snapshot, PersistenceOperation operation) {
        try {
            for (PrePersistenceListener listener : this.prePersistListeners) {
                listener.persistObject(snapshot, operation);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("An error occured notifying pre persist listeners.", (Throwable)ex);
        }
    }

    public void notifyPrePersist(PersistentObjDescriptor snapshot, PersistenceOperation operation) {
        try {
            for (PrePersistenceListener listener : this.prePersistListeners) {
                listener.persistObject(snapshot, operation);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("An error occured notifying pre persist listeners.", (Throwable)ex);
        }
    }
}

