/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.synchronisation;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.synchronisation.Converter;
import java.util.Map;
import ordermate.OrderMate;

public class PersistentEnumConverter
implements Converter {
    private final Class type;
    private final Map register;

    public PersistentEnumConverter(Class type, Map register) {
        this.type = type;
        this.register = register;
    }

    @Override
    public Object convert(Object value, PropertiedObject.Property property, PersistentObjectI owner) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Cannot convert " + value + " to a " + this.getType() + " from a " + value.getClass());
        }
        String key = (String)value;
        Object obj = this.register.get(key);
        if (obj == null) {
            OrderMate.LOG.warn("EnumConverter - Could not find key in register : " + key + " for type: " + this.type + " with property: " + property);
        }
        return obj;
    }

    @Override
    public Class getType() {
        return this.type;
    }
}

