/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.synchronisation;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.synchronisation.Converter;
import au.com.ordermate.util.Price;

public class PriceConverter
implements Converter {
    @Override
    public Object convert(Object value, PropertiedObject.Property property, PersistentObjectI owner) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Cannot convert " + value + " to a Price from a " + value.getClass());
        }
        Double price = (Double)value;
        PersistenceMetaData meta = PersistenceManager.getPersistenceMetaData();
        Double rounding = (Double)meta.getPropertyMetadata(property).get("price rounding");
        Price newPrice = rounding == null ? new Price(price, 0.0) : new Price(price, (double)rounding);
        return newPrice;
    }

    @Override
    public Class getType() {
        return Price.class;
    }
}

