/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.synchronisation;

import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import au.com.ordermate.util.MathsUtils;
import java.io.Serializable;
import ordermate.hom.DbSnapshotBufferType;

public class SnapshotEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private SynchronisationSnapshot snapshot;
    private int priority;
    private DbSnapshotBufferType snapshotType;

    public String toString() {
        return this.getSnapshot().toString();
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setSnapshot(SynchronisationSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public SynchronisationSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void setPriority(int priority) {
        this.priority = MathsUtils.clamp(priority, 0, 9);
    }

    public int getPriority() {
        return this.priority;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.snapshot.getOperation());
        sb.append("[Type=");
        sb.append(this.snapshot.getObjectType());
        sb.append("; ");
        for (String property : this.snapshot.getPropertyNames()) {
            sb.append(property);
            sb.append("=");
            sb.append(this.snapshot.get(property));
            if (this.snapshot.get(property) != null) {
                sb.append("<");
                sb.append(this.snapshot.get(property).getClass().getName());
                sb.append(">");
            }
            sb.append("; ");
        }
        sb.append("]");
        return sb.toString();
    }

    public DbSnapshotBufferType getSnapshotType() {
        return this.snapshotType;
    }

    public void setSnapshotType(DbSnapshotBufferType snapshotType) {
        this.snapshotType = snapshotType;
    }
}

