/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.synchronisation;

import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;

public class SynchronisationSnapshot
implements Serializable {
    public static final long serialVersionUID = 5959172216118902674L;
    private final PersistenceOperation operation;
    private final String objectType;
    private final Map<String, Object> messageMap = new HashMap<String, Object>();

    public SynchronisationSnapshot(PersistenceOperation operationType, String type) {
        this.operation = operationType;
        this.objectType = type;
    }

    public Set<String> getPropertyNames() {
        return this.messageMap.keySet();
    }

    public Object get(String property) {
        return this.messageMap.get(property);
    }

    public void put(String property, Object value) {
        if (value instanceof PersistentEnumeration || value instanceof Enum) {
            value = value.toString();
        }
        if (value != null && !value.getClass().getName().startsWith("java")) {
            OrderMate.LOG.warn("The value " + value + " is not a primitive or a java type but a " + value.getClass().getName());
        }
        this.messageMap.put(property, value);
    }

    public void remove(String property) {
        this.messageMap.remove(property);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public PersistenceOperation getOperation() {
        return this.operation;
    }

    public String toString() {
        return this.objectType + "-" + (Object)((Object)this.operation) + ": " + this.messageMap;
    }

    public boolean containsProperty(String property) {
        return this.messageMap.get(property) != null;
    }
}

