/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.util.property;

import au.com.ordermate.operator.date.DateOperatorFactory;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.util.property.PropertyValueHelper;
import au.com.ordermate.persistence.util.property.comparison.ComparisonType;
import au.com.ordermate.persistence.util.property.comparison.PropertyComparison;
import au.com.ordermate.persistence.util.property.comparison.PropertyComparisonFactory;
import au.com.ordermate.persistence.util.property.operation.OperationType;
import au.com.ordermate.persistence.util.property.operation.ValueOperation;
import au.com.ordermate.persistence.util.property.operation.ValueOperationFactory;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ordermate.OrderMate;

public abstract class AbstractPropertyValueHelper
implements PropertyValueHelper {
    public static final String NULL = "<null>";
    public static final String NOW = "<now>";
    public static final String DATE = "<date>";
    private final DateFormat format = new SimpleDateFormat("dd/MM");

    @Override
    public ValueOperation findOperation(OperationType type) {
        return ValueOperationFactory.createOperationFor(type);
    }

    @Override
    public PropertyComparison findComparison(ComparisonType type) {
        return PropertyComparisonFactory.createComparisonFor(type);
    }

    @Override
    public PropertiedObject.Property resolveProperty(Class<? extends PropertiedObject> clazz, String clazzPropString) {
        if (clazzPropString == null) {
            return null;
        }
        int index = clazzPropString.indexOf(".");
        if (index < 2) {
            return null;
        }
        String propString = clazzPropString.substring(index + 1).trim();
        try {
            Field field = clazz.getField("Properties");
            PropertiedObject.Props props = (PropertiedObject.Props)field.get(null);
            return props.getProperty(propString);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot resolve Property:" + propString + " for clazz :" + clazz);
            return null;
        }
    }

    @Override
    public Object getTransformedValue(ValueOperation op, Object someValue) {
        return op.operate(someValue);
    }

    @Override
    public Object resolveValue(String propertyString) {
        if (NULL.equalsIgnoreCase(propertyString)) {
            return null;
        }
        if (NOW.equalsIgnoreCase(propertyString)) {
            return new Date();
        }
        if (StringUtils.startsWithIgnoreCase(propertyString, DATE)) {
            String val = propertyString.substring(propertyString.indexOf(">") + 1);
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.format.parse(val));
                cal.set(1, DateTimeUtils.getCurrentYear());
                return cal.getTime();
            }
            catch (ParseException ex) {
                OrderMate.LOG.warn("Cannot parse date, must be in format of dd/MM");
                DateOperatorFactory factory = new DateOperatorFactory();
                return factory.createOperator(val).getValue();
            }
        }
        PropertiedObject.Property resolvedProperty = this.resolveProperty(this.resolveClazz(propertyString), propertyString);
        if (resolvedProperty != null) {
            return this.resolvePropertyValue(resolvedProperty);
        }
        Object value = this.resolveObject(propertyString);
        if (value != null) {
            return value;
        }
        return propertyString;
    }

    protected abstract Object resolveObject(String var1);

    protected abstract Object resolvePropertyValue(PropertiedObject.Property var1);
}

