/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.util.property.comparison;

import au.com.ordermate.persistence.util.property.comparison.AfterIncComparison;
import au.com.ordermate.persistence.util.property.comparison.BeforeIncComparison;
import au.com.ordermate.persistence.util.property.comparison.ComparisonType;
import au.com.ordermate.persistence.util.property.comparison.EqualsComparison;
import au.com.ordermate.persistence.util.property.comparison.PropertyComparison;
import au.com.ordermate.persistence.util.property.comparison.StartsWithComparison;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;

public class PropertyComparisonFactory {
    private static final Map<ComparisonType, Class<? extends PropertyComparison>> map = new HashMap<ComparisonType, Class<? extends PropertyComparison>>();

    private PropertyComparisonFactory() {
    }

    public static PropertyComparison createComparisonFor(ComparisonType compType) {
        Class<? extends PropertyComparison> clazz = map.get((Object)compType);
        if (clazz == null) {
            throw new IllegalArgumentException("I don't know about this comparison type!" + (Object)((Object)compType));
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            OrderMate.LOG.error("Cannot instantiate property comparison:", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            OrderMate.LOG.error("Cannot instantiate property comparison:", (Throwable)ex);
        }
        return null;
    }

    static {
        map.put(ComparisonType.Equals, EqualsComparison.class);
        map.put(ComparisonType.StartsWith, StartsWithComparison.class);
        map.put(ComparisonType.BeforeInc, BeforeIncComparison.class);
        map.put(ComparisonType.AfterInc, AfterIncComparison.class);
    }
}

