/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.util.property.operation;

import au.com.ordermate.persistence.util.property.operation.DateOfYearifyOperation;
import au.com.ordermate.persistence.util.property.operation.DateifyOperation;
import au.com.ordermate.persistence.util.property.operation.DoublifyOperation;
import au.com.ordermate.persistence.util.property.operation.IntegerifyOperation;
import au.com.ordermate.persistence.util.property.operation.MonthifyOperation;
import au.com.ordermate.persistence.util.property.operation.NoOpOperation;
import au.com.ordermate.persistence.util.property.operation.OperationType;
import au.com.ordermate.persistence.util.property.operation.PriceifyOperation;
import au.com.ordermate.persistence.util.property.operation.ValueOperation;
import au.com.ordermate.persistence.util.property.operation.WeekifyOperation;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;

public class ValueOperationFactory {
    private static final Map<OperationType, Class<? extends ValueOperation>> map = new HashMap<OperationType, Class<? extends ValueOperation>>();

    private ValueOperationFactory() {
    }

    public static ValueOperation createOperationFor(OperationType opType) {
        Class<? extends ValueOperation> clazz = map.get((Object)opType);
        if (clazz == null) {
            throw new IllegalArgumentException("I don't know about this Operation Type!" + (Object)((Object)opType));
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            OrderMate.LOG.error("Cannot instantiate operation:", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            OrderMate.LOG.error("Cannot instantiate operation:", (Throwable)ex);
        }
        return null;
    }

    static {
        map.put(OperationType.NoOp, NoOpOperation.class);
        map.put(OperationType.Week, WeekifyOperation.class);
        map.put(OperationType.Month, MonthifyOperation.class);
        map.put(OperationType.DayOfMonth, DateOfYearifyOperation.class);
        map.put(OperationType.Price, PriceifyOperation.class);
        map.put(OperationType.Integer, IntegerifyOperation.class);
        map.put(OperationType.Double, DoublifyOperation.class);
        map.put(OperationType.Date, DateifyOperation.class);
    }
}

