/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.pipeline;

import au.com.ordermate.pipeline.AbstractPipe;
import au.com.ordermate.pipeline.GenericPipe;
import java.util.ArrayList;

public class GenericPipeline<InputType, OutputType>
extends AbstractPipe<InputType, OutputType> {
    private ArrayList<GenericPipe<?, ?>> pieces = new ArrayList();

    public GenericPipeline(Class<InputType> inputType, Class<OutputType> outputType) {
        super(inputType, outputType);
    }

    @Override
    public OutputType doPump(InputType input) {
        Object flow = input;
        for (GenericPipe<?, ?> piece : this.pieces) {
            try {
                flow = piece.pump(flow);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Possible Pipe input mismatch, expected " + piece.getInputType() + " but was given " + flow.getClass(), e);
            }
        }
        try {
            return this.getOutputType().cast(flow);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Possible Pipeline output type mismatch, expected " + this.getOutputType() + " but ended up with " + flow.getClass(), e);
        }
    }

    public void addPipe(int index, GenericPipe<?, ?> piece) {
        this.pieces.add(index, piece);
    }

    public void addPipe(GenericPipe<?, ?> piece) {
        this.pieces.add(piece);
    }

    public void removePipe(GenericPipe<?, ?> piece) {
        this.pieces.remove(piece);
    }

    public void clearPipes() {
        this.pieces.clear();
    }
}

