/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.reflect;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public final class ConversionUtils {
    public static boolean getAsBoolean(Object value) {
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue() != 0.0;
            }
            if (value instanceof Character) {
                return ((Character)value).charValue() != '\u0000';
            }
            if (value instanceof String) {
                return ((String)value).length() != 0;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size() != 0;
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value) != 0;
            }
            return true;
        }
        return false;
    }

    public static Object convertObject(Object o, Class type) {
        if (o == null) {
            return null;
        }
        Class<?> actualType = o.getClass();
        if (type.isAssignableFrom(actualType)) {
            return o;
        }
        if (ConversionUtils.isIntegerClass(type)) {
            return ConversionUtils.getAsInteger(o);
        }
        if (ConversionUtils.isDoubleClass(type)) {
            return ConversionUtils.getAsInteger(o);
        }
        if (ConversionUtils.isBooleanClass(type)) {
            return ConversionUtils.getAsBoolean(o);
        }
        if (type.isAssignableFrom(Collection.class)) {
            return ConversionUtils.getAsCollection(o);
        }
        if (type.isArray()) {
            return ConversionUtils.getAsObjectArray(o);
        }
        if (type.equals(String.class)) {
            return String.valueOf(o);
        }
        return null;
    }

    public static boolean isBooleanClass(Class type) {
        return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
    }

    public static boolean isIntegerClass(Class type) {
        return type.equals(Integer.TYPE) || type.equals(Integer.class);
    }

    public static boolean isDoubleClass(Class type) {
        return type.equals(Double.TYPE) || type.equals(Double.class);
    }

    public static boolean isNumberClass(Class type) {
        return type.isAssignableFrom(Number.class) || type.equals(Integer.TYPE) || type.equals(Double.TYPE) || type.equals(Float.TYPE) || type.equals(Long.TYPE) || type.equals(Short.TYPE);
    }

    public static boolean convertedEquals(Object obj1, Object obj2) {
        if (obj1 != null) {
            if (obj1 instanceof String) {
                return obj1.equals(String.valueOf(obj2));
            }
            if (obj1 instanceof Number) {
                return ((Number)obj1).doubleValue() == ConversionUtils.getAsDouble(obj2);
            }
            if (obj1 instanceof Boolean) {
                return (Boolean)obj1 == ConversionUtils.getAsBoolean(obj2);
            }
            if (obj1 instanceof Collection) {
                return obj1.equals(ConversionUtils.getAsCollection(obj2));
            }
            if (obj1.getClass().isArray()) {
                return Arrays.equals(ConversionUtils.getAsObjectArray(obj1), ConversionUtils.getAsObjectArray(obj2));
            }
            return obj1.equals(obj2);
        }
        return obj2 == null;
    }

    public static int getAsInteger(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                try {
                    return Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            if (value instanceof Character) {
                return ((Character)value).charValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
            return 0;
        }
        return 0;
    }

    public static double getAsDouble(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                try {
                    return Double.parseDouble((String)value);
                }
                catch (NumberFormatException e) {
                    return 0.0;
                }
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    public static Object[] getAsObjectArray(Object array) {
        Object[] retval;
        block11: {
            String name;
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block10: {
                                            Class<?> arrayClass = array.getClass();
                                            if (array instanceof Collection) {
                                                return ((Collection)array).toArray();
                                            }
                                            if (!arrayClass.isArray()) {
                                                return new Object[]{array};
                                            }
                                            name = arrayClass.getName();
                                            retval = null;
                                            if (!name.startsWith("[L")) break block10;
                                            retval = (Object[])array;
                                            break block11;
                                        }
                                        if (!name.equals("[I")) break block12;
                                        int[] values = (int[])array;
                                        retval = new Object[values.length];
                                        for (int i = 0; i < values.length; ++i) {
                                            retval[i] = values[i];
                                        }
                                        break block11;
                                    }
                                    if (!name.equals("[J")) break block13;
                                    long[] values = (long[])array;
                                    retval = new Object[values.length];
                                    for (int i = 0; i < values.length; ++i) {
                                        retval[i] = values[i];
                                    }
                                    break block11;
                                }
                                if (!name.equals("[Z")) break block14;
                                boolean[] values = (boolean[])array;
                                retval = new Object[values.length];
                                for (int i = 0; i < values.length; ++i) {
                                    retval[i] = values[i];
                                }
                                break block11;
                            }
                            if (!name.equals("[C")) break block15;
                            char[] values = (char[])array;
                            retval = new Object[values.length];
                            for (int i = 0; i < values.length; ++i) {
                                retval[i] = Character.valueOf(values[i]);
                            }
                            break block11;
                        }
                        if (!name.equals("[D")) break block16;
                        double[] values = (double[])array;
                        retval = new Object[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            retval[i] = new Double(values[i]);
                        }
                        break block11;
                    }
                    if (!name.equals("[F")) break block17;
                    float[] values = (float[])array;
                    retval = new Object[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        retval[i] = new Float(values[i]);
                    }
                    break block11;
                }
                if (!name.equals("[S")) break block18;
                short[] values = (short[])array;
                retval = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    retval[i] = values[i];
                }
                break block11;
            }
            if (!name.equals("[B")) break block11;
            byte[] values = (byte[])array;
            retval = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                retval[i] = values[i];
            }
        }
        return retval;
    }

    public static Class getAsPrimitiveClass(Class c) {
        if (c.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (c.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (c.equals(Long.class)) {
            return Long.TYPE;
        }
        if (c.equals(Short.class)) {
            return Short.TYPE;
        }
        if (c.equals(Character.class)) {
            return Character.TYPE;
        }
        if (c.equals(Float.class)) {
            return Float.TYPE;
        }
        if (c.equals(Double.class)) {
            return Double.TYPE;
        }
        return c;
    }

    public static Collection getAsCollection(Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                return (Collection)value;
            }
            if (value.getClass().isArray()) {
                Object[] array = ConversionUtils.getAsObjectArray(value);
                return Arrays.asList(array);
            }
            ArrayList<Object> singleton = new ArrayList<Object>();
            singleton.add(value);
            return singleton;
        }
        return new ArrayList();
    }

    private ConversionUtils() {
    }
}

