/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.reflect;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.keyvalue.MultiKey;

public class FieldUtils {
    private static final Map<MultiKey, Field> fieldMap = new HashMap<MultiKey, Field>();

    private FieldUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field getField(Class clazz, String name) throws Exception {
        MultiKey key = new MultiKey((Object)clazz, (Object)name);
        Field field = fieldMap.get(key);
        if (field != null) {
            return field;
        }
        try {
            field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            Map<MultiKey, Field> map = fieldMap;
            synchronized (map) {
                if (!fieldMap.containsKey(key)) {
                    fieldMap.put(key, field);
                } else {
                    field = fieldMap.get(key);
                }
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            if (!clazz.equals(Object.class)) {
                field = FieldUtils.getField(clazz.getSuperclass(), name);
                if (field != null) {
                    fieldMap.put(key, field);
                }
                return field;
            }
            throw e;
        }
    }

    public static void setValue(Object owner, String field, Object value) throws Exception {
        Field toGet = FieldUtils.getField(owner.getClass(), field);
        toGet.set(owner, value);
    }

    public static Object getValue(Object owner, String field) throws Exception {
        Field toGet = FieldUtils.getField(owner.getClass(), field);
        Object value = toGet.get(owner);
        return value;
    }
}

