/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.reflect;

import au.com.ordermate.expr.ParseEngine;
import au.com.ordermate.expr.Parser;
import au.com.ordermate.expr.RPNParser;
import au.com.ordermate.expr.Symbol;
import au.com.ordermate.expr.SymbolTree;
import au.com.ordermate.reflect.ConversionUtils;
import au.com.ordermate.reflect.ReflectUtils;
import au.com.ordermate.reflect.SyntaxException;
import au.com.ordermate.reflect.UnresolvedVariableException;
import au.com.ordermate.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public final class PropertyUtils {
    private static final int SYMBOL_NEST = 0;
    private static final int SYMBOL_METHOD_PARAM = 1;
    private static final int SYMBOL_INDEXED_OPEN = 2;
    private static final int SYMBOL_INDEXED_CLOSE = 3;
    private static final int SYMBOL_MAPPED_OPEN = 4;
    private static final int SYMBOL_MAPPED_CLOSE = 5;
    private static final int SYMBOL_NOT = 6;
    private static final int SYMBOL_EQUALS = 7;
    private static final int SYMBOL_NOTEQUALS = 8;
    private static final int SYMBOL_GREATERTHAN = 9;
    private static final int SYMBOL_LESSTHAN = 10;
    private static final int SYMBOL_GREATERTHANEQ = 11;
    private static final int SYMBOL_LESSTHANEQ = 12;
    private static final int SYMBOL_AND = 13;
    private static final int SYMBOL_OR = 14;
    private static final int SYMBOL_PLUS = 15;
    private static final int SYMBOL_MINUS = 16;
    private static final int SYMBOL_MULT = 17;
    private static final int SYMBOL_DIV = 18;
    private static final int SYMBOL_TEXT = -1;
    private static final int SYMBOL_UNRECOGNISED = -2;
    private static final String[] OPERATOR_STRINGS = new String[]{".", ",", "[", "]", "(", ")", "!", "==", "!=", ">", "<", ">=", "<=", "&&", "||", "+", "-", "*", "/"};
    private static final String[] OPERATOR_WORDS = new String[]{".", ",", "[", "]", "(", ")", "not", "eq", "not_eq", "gt", "lt", "gte", "lte", "and", "or", "_plus", "_minus", "mult", "div"};
    private static final ParseEngine parseEngine = new ParseEngine();
    private static final Parser parser = new PropertyParser();
    private static final Hashtable exprCache = new Hashtable();
    private static GlobalVariableResolver[] globalResolvers = new GlobalVariableResolver[0];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getSimpleProperty(Object userObject, String propName, List theParams) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List params = theParams;
        if (params == null) {
            params = new ParamList();
        }
        Object retval = null;
        Class<?> userObjClass = null;
        if (userObject != null) {
            String hasPropName;
            String isPropName;
            userObjClass = userObject instanceof Class ? (Class<?>)userObject : userObject.getClass();
            String getPropName = ReflectUtils.convertPropertyName(propName, "get");
            Method method = ReflectUtils.getMethodSuitableForParams(userObjClass, getPropName, params.toArray());
            if (method == null && (method = ReflectUtils.getMethodSuitableForParams(userObjClass, isPropName = ReflectUtils.convertPropertyName(propName, "is"), params.toArray())) != null && !method.getReturnType().equals(Boolean.TYPE)) {
                method = null;
            }
            if (method == null && (method = ReflectUtils.getMethodSuitableForParams(userObjClass, hasPropName = ReflectUtils.convertPropertyName(propName, "has"), params.toArray())) != null && !method.getReturnType().equals(Boolean.TYPE)) {
                method = null;
            }
            Field field = null;
            if (method == null) {
                method = ReflectUtils.getMethodSuitableForParams(userObjClass, propName, params.toArray());
            }
            if (method == null && params.isEmpty()) {
                try {
                    field = userObjClass.getDeclaredField(propName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            if (method != null) {
                return ReflectUtils.invokeMethod(method, userObject, params);
            }
            if (field != null) {
                return field.get(userObject);
            }
            String errorString = "Couldn't find property " + userObjClass.getName() + "." + propName + " or ." + getPropName + " for object " + userObject + " of type " + userObject.getClass().getName() + " with params " + params;
            throw new NoSuchMethodException(errorString);
        }
        int i = 0;
        while (i < globalResolvers.length) {
            GlobalVariableResolver resolver = globalResolvers[i];
            try {
                return resolver.resolveGlobal(propName);
            }
            catch (UnresolvedVariableException e) {
                ++i;
            }
        }
        return retval;
    }

    private static String getFromTextSymbolAsLiteralString(Symbol symbol) throws SyntaxException {
        PropertyUtils.testSymbolID(symbol, -1);
        String text = symbol.getText();
        if (text.length() >= 2 && (text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"' || text.charAt(0) == '\'' && text.charAt(text.length() - 1) == '\'')) {
            return text.substring(1, text.length() - 1);
        }
        return null;
    }

    private static Boolean getFromTextSymbolAsBoolean(Symbol symbol) throws SyntaxException {
        PropertyUtils.testSymbolID(symbol, -1);
        String text = symbol.getText();
        if (text.equals("true")) {
            return Boolean.TRUE;
        }
        if (text.equals("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static Integer getFromTextSymbolAsInteger(Symbol symbol) throws SyntaxException {
        PropertyUtils.testSymbolID(symbol, -1);
        try {
            int integer = Integer.parseInt(symbol.getText());
            return integer;
        }
        catch (NumberFormatException n) {
            return null;
        }
    }

    private static Object getFromTextSymbol(Object userObject, Symbol symbol) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, -1);
        if (symbol.getText().equals("null")) {
            return null;
        }
        if (symbol.getText().equals("this")) {
            return userObject;
        }
        Object retval = PropertyUtils.getFromTextSymbolAsLiteralString(symbol);
        if (retval != null) {
            return retval;
        }
        retval = PropertyUtils.getFromTextSymbolAsBoolean(symbol);
        if (retval != null) {
            return retval;
        }
        retval = PropertyUtils.getFromTextSymbolAsInteger(symbol);
        if (retval != null) {
            return retval;
        }
        retval = PropertyUtils.getSimpleProperty(userObject, symbol.getText(), null);
        return retval;
    }

    private static Symbol getChildOne(Symbol symbol) {
        return symbol.getFirstChild();
    }

    private static Symbol getChildTwo(Symbol symbol) {
        return symbol.getFirstChild().getNextPeer();
    }

    private static Object getFromDotSymbol(Object theUserObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        Object userObject = theUserObject;
        PropertyUtils.testSymbolID(symbol, 0);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        userObject = PropertyUtils.getFromSymbol(userObject, child1);
        return PropertyUtils.getFromSymbol(userObject, child2);
    }

    private static ParamList getFromCommaSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 1);
        ParamList retval = new ParamList();
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        if (obj1 instanceof ParamList) {
            retval.addAll((ParamList)obj1);
        } else {
            retval.add(obj1);
        }
        if (obj2 instanceof ParamList) {
            retval.addAll((ParamList)obj2);
        } else {
            retval.add(obj2);
        }
        return retval;
    }

    private static Boolean getFromEqualsSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 7);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return ConversionUtils.convertedEquals(obj1, obj2);
    }

    private static Boolean getFromNotEqualsSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 8);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return !ConversionUtils.convertedEquals(obj1, obj2);
    }

    private static Boolean getFromGreaterThanSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 9);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return ConversionUtils.getAsDouble(obj1) > ConversionUtils.getAsDouble(obj2);
    }

    private static Boolean getFromGreaterThanEqSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 11);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return ConversionUtils.getAsDouble(obj1) >= ConversionUtils.getAsDouble(obj2);
    }

    private static Boolean getFromLessThanEqSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 12);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return ConversionUtils.getAsDouble(obj1) <= ConversionUtils.getAsDouble(obj2);
    }

    private static Boolean getFromLessThanSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 10);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return ConversionUtils.getAsDouble(obj1) < ConversionUtils.getAsDouble(obj2);
    }

    private static Boolean getFromAndSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 13);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        boolean firstArgTrue = ConversionUtils.getAsBoolean(obj1);
        if (firstArgTrue) {
            Symbol child2 = PropertyUtils.getChildTwo(symbol);
            Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
            boolean secondArgTrue = ConversionUtils.getAsBoolean(obj2);
            return secondArgTrue ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    private static Boolean getFromOrSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 14);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return ConversionUtils.getAsBoolean(obj1) || ConversionUtils.getAsBoolean(obj2);
    }

    private static Number getFromPlusSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 15);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return new Double(ConversionUtils.getAsDouble(obj1) + ConversionUtils.getAsDouble(obj2));
    }

    private static Number getFromMinusSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 16);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return new Double(ConversionUtils.getAsDouble(obj1) - ConversionUtils.getAsDouble(obj2));
    }

    private static Number getFromMultSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 17);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return new Double(ConversionUtils.getAsDouble(obj1) * ConversionUtils.getAsDouble(obj2));
    }

    private static Number getFromDivSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 18);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Object obj2 = PropertyUtils.getFromSymbol(userObject, child2);
        return new Double(ConversionUtils.getAsDouble(obj1) / ConversionUtils.getAsDouble(obj2));
    }

    private static Boolean getFromNotSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 6);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        return !ConversionUtils.getAsBoolean(obj1);
    }

    private static Object getFromIndexedSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 2);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        if (child1 == null) {
            PropertyUtils.throwSyntaxException("Indexed property: missing operand between brackets");
        }
        if (child2 == null) {
            PropertyUtils.throwSyntaxException("Indexed property: missing operand before brackets");
        }
        Object obj1 = PropertyUtils.getFromSymbol(userObject, child1);
        Integer number = PropertyUtils.getFromTextSymbolAsInteger(child2);
        if (number == null) {
            PropertyUtils.throwSyntaxException("Index couldn't be parsed as an integer.");
        } else {
            if (obj1.getClass().isArray()) {
                Object[] array = ConversionUtils.getAsObjectArray(obj1);
                return array[number];
            }
            if (obj1 instanceof List) {
                return ((List)obj1).get(number);
            }
            PropertyUtils.throwSyntaxException("Indexed property does not appear to be of an indexable type: " + obj1.getClass().getName());
        }
        return null;
    }

    private static Object getFromMappedSymbol(Object userObject, Symbol symbol) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, SyntaxException {
        PropertyUtils.testSymbolID(symbol, 4);
        Symbol child1 = PropertyUtils.getChildOne(symbol);
        Symbol child2 = PropertyUtils.getChildTwo(symbol);
        String propName = child1.getText();
        Object paramContainer = PropertyUtils.getFromSymbol(null, child2);
        if (propName == null) {
            PropertyUtils.throwSyntaxException("Expected mapped property name is null from object: " + child1);
        }
        List<Object> params = null;
        params = paramContainer instanceof ParamList ? (List<Object>)paramContainer : Collections.singletonList(paramContainer);
        return PropertyUtils.getSimpleProperty(userObject, propName, params);
    }

    private static Object getFromSymbol(Object userObject, Symbol symbol) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        Object retval = null;
        int id = symbol.getID();
        switch (id) {
            case -1: {
                retval = PropertyUtils.getFromTextSymbol(userObject, symbol);
                break;
            }
            case 0: {
                retval = PropertyUtils.getFromDotSymbol(userObject, symbol);
                break;
            }
            case 1: {
                retval = PropertyUtils.getFromCommaSymbol(userObject, symbol);
                break;
            }
            case 2: {
                retval = PropertyUtils.getFromIndexedSymbol(userObject, symbol);
                break;
            }
            case 4: {
                retval = PropertyUtils.getFromMappedSymbol(userObject, symbol);
                break;
            }
            case 7: {
                retval = PropertyUtils.getFromEqualsSymbol(userObject, symbol);
                break;
            }
            case 8: {
                retval = PropertyUtils.getFromNotEqualsSymbol(userObject, symbol);
                break;
            }
            case 6: {
                retval = PropertyUtils.getFromNotSymbol(userObject, symbol);
                break;
            }
            case 9: {
                retval = PropertyUtils.getFromGreaterThanSymbol(userObject, symbol);
                break;
            }
            case 10: {
                retval = PropertyUtils.getFromLessThanSymbol(userObject, symbol);
                break;
            }
            case 11: {
                retval = PropertyUtils.getFromGreaterThanEqSymbol(userObject, symbol);
                break;
            }
            case 12: {
                retval = PropertyUtils.getFromLessThanEqSymbol(userObject, symbol);
                break;
            }
            case 13: {
                retval = PropertyUtils.getFromAndSymbol(userObject, symbol);
                break;
            }
            case 14: {
                retval = PropertyUtils.getFromOrSymbol(userObject, symbol);
                break;
            }
            case 15: {
                retval = PropertyUtils.getFromPlusSymbol(userObject, symbol);
                break;
            }
            case 16: {
                retval = PropertyUtils.getFromMinusSymbol(userObject, symbol);
                break;
            }
            case 17: {
                retval = PropertyUtils.getFromMultSymbol(userObject, symbol);
                break;
            }
            case 18: {
                retval = PropertyUtils.getFromDivSymbol(userObject, symbol);
                break;
            }
            default: {
                PropertyUtils.throwSyntaxException("Unrecognised symbol ID: " + id + " text: " + symbol.getText());
                return null;
            }
        }
        return retval;
    }

    private static void throwSyntaxException(String msg) throws SyntaxException {
        throw new SyntaxException("PropertyUtils Syntax Exception: " + msg);
    }

    private static void testSymbolID(Symbol symbol, int expectedID) throws SyntaxException {
        int id = symbol.getID();
        if (id != expectedID) {
            PropertyUtils.throwSyntaxException("Expected symbol type " + expectedID + ", got " + id);
        }
    }

    public static Object getProperty(Object userObject, String property, GlobalVariableResolver[] resolvers) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        try {
            globalResolvers = resolvers;
            parser.resetState();
            SymbolTree symbols = PropertyUtils.getParseTree(property);
            return PropertyUtils.getFromSymbol(userObject, symbols.getFirstChild());
        }
        catch (IOException ioe) {
            throw new InvocationTargetException(ioe);
        }
    }

    public static Object getProperty(Object userObject, String property, GlobalVariableResolver globalResolver) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        try {
            globalResolvers = new GlobalVariableResolver[]{globalResolver};
            parser.resetState();
            SymbolTree symbols = PropertyUtils.getParseTree(property);
            return PropertyUtils.getFromSymbol(userObject, symbols.getFirstChild());
        }
        catch (IOException ioe) {
            throw new InvocationTargetException(ioe);
        }
    }

    public static Object getProperty(Object userObject, String property) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SyntaxException {
        try {
            parser.resetState();
            SymbolTree symbols = PropertyUtils.getParseTree(property);
            return PropertyUtils.getFromSymbol(userObject, symbols.getFirstChild());
        }
        catch (IOException ioe) {
            throw new InvocationTargetException(ioe);
        }
    }

    private static SymbolTree getParseTree(String expr) throws IOException {
        SymbolTree tree = (SymbolTree)exprCache.get(expr);
        if (tree == null) {
            tree = parseEngine.parse(expr, parser);
            exprCache.put(expr, tree);
        }
        return tree;
    }

    private PropertyUtils() {
    }

    private static class PropertyParser
    extends RPNParser {
        public PropertyParser() {
            this.addBracketOperator(OPERATOR_STRINGS[4], OPERATOR_STRINGS[5], 1);
            this.addOperator(OPERATOR_STRINGS[0], 3);
            this.addBracketOperator(OPERATOR_STRINGS[2], OPERATOR_STRINGS[3], 1, true);
            this.addOperator(OPERATOR_STRINGS[17], 3);
            this.addOperator(OPERATOR_WORDS[17], 3);
            this.addOperator(OPERATOR_STRINGS[18], 3);
            this.addOperator(OPERATOR_WORDS[18], 3);
            this.addOperator(OPERATOR_STRINGS[15], 3);
            this.addOperator(OPERATOR_WORDS[15], 3);
            this.addOperator(OPERATOR_STRINGS[16], 3);
            this.addOperator(OPERATOR_WORDS[16], 3);
            this.addOperator(OPERATOR_STRINGS[9], 3);
            this.addOperator(OPERATOR_WORDS[9], 3, true);
            this.addOperator(OPERATOR_STRINGS[10], 3);
            this.addOperator(OPERATOR_WORDS[10], 3, true);
            this.addOperator(OPERATOR_STRINGS[11], 3);
            this.addOperator(OPERATOR_WORDS[11], 3, true);
            this.addOperator(OPERATOR_STRINGS[12], 3);
            this.addOperator(OPERATOR_WORDS[12], 3, true);
            this.addOperator(OPERATOR_STRINGS[8], 3);
            this.addOperator(OPERATOR_WORDS[8], 3, true);
            this.addOperator(OPERATOR_STRINGS[7], 3);
            this.addOperator(OPERATOR_WORDS[7], 3, true);
            this.addOperator(OPERATOR_STRINGS[6], 2);
            this.addOperator(OPERATOR_WORDS[6], 2, true);
            this.addOperator(OPERATOR_STRINGS[14], 3);
            this.addOperator(OPERATOR_WORDS[14], 3, true);
            this.addOperator(OPERATOR_STRINGS[13], 3);
            this.addOperator(OPERATOR_WORDS[13], 3, true);
            this.addOperator(OPERATOR_STRINGS[1], 3);
        }

        @Override
        public int getSymbolID(String symbolText) {
            for (int i = 0; i < OPERATOR_STRINGS.length; ++i) {
                if (!symbolText.equals(OPERATOR_STRINGS[i]) && !symbolText.equals(OPERATOR_WORDS[i])) continue;
                return i;
            }
            if (StringUtils.isValidJavaIdentifierChars(StringUtils.stripQuotes(symbolText))) {
                return -1;
            }
            return -2;
        }
    }

    public static interface GlobalVariableResolver {
        public Object resolveGlobal(String var1) throws UnresolvedVariableException;
    }

    private static class ParamList
    extends ArrayList {
        private ParamList() {
        }
    }
}

