/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.reflect;

import au.com.ordermate.reflect.ConversionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class ReflectUtils {
    private static Package[] packages = Package.getPackages();

    public static String convertPropertyName(String rawPropName, String prefix) {
        String firstLetter = String.valueOf(rawPropName.charAt(0));
        String methodName = prefix + firstLetter.toUpperCase() + rawPropName.substring(1, rawPropName.length());
        return methodName;
    }

    public static void setKVProperty(Object target, String propName, Object key, Object val) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class keyClass = ConversionUtils.getAsPrimitiveClass(key.getClass());
        Class valClass = ConversionUtils.getAsPrimitiveClass(val.getClass());
        String methodName = ReflectUtils.convertPropertyName(propName, "set");
        Method method = target.getClass().getMethod(methodName, keyClass, valClass);
        method.invoke(target, key, val);
    }

    public static Object getKVProperty(Object target, String propName, Object key) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Method methodToCall;
        block4: {
            Class keyClass = ConversionUtils.getAsPrimitiveClass(key.getClass());
            String getMethodName = ReflectUtils.convertPropertyName(propName, "get");
            String isMethodName = ReflectUtils.convertPropertyName(propName, "is");
            String hasMethodName = ReflectUtils.convertPropertyName(propName, "has");
            methodToCall = null;
            try {
                methodToCall = target.getClass().getMethod(getMethodName, keyClass);
            }
            catch (NoSuchMethodException e) {
                try {
                    methodToCall = target.getClass().getMethod(isMethodName, keyClass);
                }
                catch (NoSuchMethodException ex) {
                    methodToCall = target.getClass().getMethod(hasMethodName, keyClass);
                }
                if (methodToCall.getReturnType().equals(Boolean.TYPE)) break block4;
                throw e;
            }
        }
        return methodToCall.invoke(target, key);
    }

    public static Method getMethodSuitableForParams(Class cls, String methodName, Class[] paramTypes) {
        Method[] methods = cls.getMethods();
        ArrayList<Method> methodList = new ArrayList<Method>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(methodName) || !ReflectUtils.isMethodSuitableForParamTypes(m, paramTypes)) continue;
            methodList.add(m);
        }
        if (methodList.isEmpty()) {
            return null;
        }
        return (Method)methodList.get(0);
    }

    public static Method getMethodSuitableForParams(Class cls, String methodName, Object[] params) {
        Class[] paramTypes = new Class[params.length];
        for (int j = 0; j < paramTypes.length; ++j) {
            paramTypes[j] = params[j] == null ? Object.class : params[j].getClass();
        }
        return ReflectUtils.getMethodSuitableForParams(cls, methodName, paramTypes);
    }

    public static boolean isMethodSuitableForParamTypes(Method method, Class[] paramTypes) {
        Class<?>[] actualParamTypes = method.getParameterTypes();
        if (actualParamTypes.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < actualParamTypes.length; ++i) {
            if (ReflectUtils.isClassSuitableForExpectedType(paramTypes[i], actualParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isClassSuitableForExpectedType(Class aType, Class theExpectedType) {
        Class expectedType = ConversionUtils.getAsPrimitiveClass(theExpectedType);
        Class type = ConversionUtils.getAsPrimitiveClass(aType);
        boolean suitable = false;
        if (type.equals(expectedType)) {
            suitable = true;
        } else if (expectedType.isAssignableFrom(type)) {
            suitable = true;
        } else if (ConversionUtils.isNumberClass(expectedType) && ConversionUtils.isNumberClass(type)) {
            suitable = true;
        }
        return suitable;
    }

    public static Class getClassForShortName(String shortName) {
        for (int i = 0; i < packages.length; ++i) {
            String packageName = packages[i].getName();
            Class<?> found = null;
            try {
                found = Class.forName(packageName + "." + shortName);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (NoClassDefFoundError e) {
                continue;
            }
            return found;
        }
        return null;
    }

    public static String getShortClassName(Class cls) {
        return cls != null ? ReflectUtils.getShortClassName(cls.getName()) : "null";
    }

    public static String getShortClassName(String fullClassName) {
        int lastIndex = fullClassName.lastIndexOf(46);
        String retval = fullClassName.substring(lastIndex + 1, fullClassName.length());
        return retval;
    }

    public static String getMethodDescription(Method method) {
        StringBuilder retval = new StringBuilder(method.getClass().getName()).append(".").append(method.getName()).append("(");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                retval.append(", ");
            }
            retval.append(paramTypes[i].getName());
        }
        retval.append(")");
        return retval.toString();
    }

    public static Object invokeMethod(Method method, Object userObject, List paramList) throws IllegalAccessException, InvocationTargetException {
        Class<?>[] expectedParamTypes = method.getParameterTypes();
        Object[] params = new Object[paramList.size()];
        int numParams = paramList.size();
        for (int i = 0; i < numParams; ++i) {
            Object convertedParam;
            Object param = paramList.get(i);
            Class<?> expectedType = expectedParamTypes[i];
            params[i] = convertedParam = ConversionUtils.convertObject(param, expectedType);
        }
        return method.invoke(userObject, params);
    }

    public static String getShortMethodDescription(Method method) {
        StringBuilder retval = new StringBuilder(ReflectUtils.getShortClassName(method.getClass()));
        retval.append(".").append(method.getName()).append("(");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                retval.append(", ");
            }
            retval.append(ReflectUtils.getShortClassName(paramTypes[i]));
        }
        retval.append(")");
        return retval.toString();
    }

    private ReflectUtils() {
    }
}

