/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.registers;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import ordermate.OrderMate;

public class RegisterEditor {
    public static final String readRegister(String location, String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + location + "\" /v \"" + key + "\"");
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            if (!output.contains(key)) {
                return null;
            }
            String[] parsed = output.split("\\s+");
            if (parsed.length > 0) {
                String result = parsed[parsed.length - 1].trim();
                String type = parsed[parsed.length - 2].trim();
                result = RegisterEditor.doParseStrategy(type, result);
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean deleteRegister(String location, String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg delete \"" + location + "\" /v \"" + key + "\" /f");
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            return output.contains("The operation completed successfully");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean writeRegister(String key, String valName, String val) {
        return RegisterEditor.writeRegister(key, valName, val, Type.REG_SZ);
    }

    public static boolean writeRegister(String key, String valName, String val, Type type) {
        try {
            String statement = "reg add \"" + key + "\" /v \"" + valName + "\" /t \"" + type.toString() + "\" /d \"\\\"" + val + "\\\"\" /f";
            statement = "reg add \"" + key + "\" /v \"" + valName + "\" /t \"" + type.toString() + "\" /d \"" + val + "\" /f";
            Process process = Runtime.getRuntime().exec(statement);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            return output.contains("The operation completed successfully");
        }
        catch (Exception e) {
            OrderMate.LOG.debug("Exception in writeRegister: ", (Throwable)e);
            return false;
        }
    }

    private static String doParseStrategy(String type, String result) {
        String toReturn = result;
        if (Type.REG_DWORD.toString().equals(type)) {
            toReturn = toReturn.startsWith("0x") ? toReturn.substring(2) : toReturn;
            toReturn = "" + Integer.parseInt(toReturn, 16);
        } else if (Type.REG_SZ.toString().equals(type)) {
            // empty if block
        }
        return toReturn;
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }

    public static enum Type {
        REG_SZ,
        REG_MULTI_SZ,
        REG_DWORD_BIG_ENDIAN,
        REG_DWORD,
        REG_BINARY,
        REG_DWORD_LITTLE_ENDIAN,
        REG_LINK,
        REG_FULL_RESOURCE_DESCRIPTOR,
        REG_EXPAND_SZ;

    }
}

