/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.reports;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.view.JRViewer;

public abstract class AbstractReport {
    private volatile JasperPrint print;
    private String fileName;
    private Map<String, Object> reportParams = new HashMap<String, Object>();
    private List<AbstractReport> subReports = new ArrayList<AbstractReport>();
    private JasperReport cachedReport;
    private List<JasperReport> cachedSubReports;
    private JRViewer viewer;

    public AbstractReport(String newFileName) {
        this.fileName = newFileName;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected void addReportParam(String key, Object value) {
        this.reportParams.put(key, value);
    }

    protected void clearReportParams() {
        this.reportParams.clear();
    }

    protected Map<String, Object> getReportParams() {
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        allParams.putAll(this.reportParams);
        for (AbstractReport report : this.getSubReports()) {
            allParams.putAll(report.getReportParams());
        }
        return allParams;
    }

    protected abstract JasperReport loadReport() throws JRException;

    protected final String getSubReportFileName(String subReportName) {
        if (!this.fileName.endsWith(".jrxml")) {
            throw new IllegalStateException("Main report file name: '" + this.fileName + "' does not end with .jrxml");
        }
        String name = this.fileName.substring(0, this.fileName.length() - 6);
        name = name + subReportName + ".jrxml";
        return name;
    }

    protected final void addSubReport(AbstractReport toAdd) {
        this.subReports.add(toAdd);
    }

    protected final List<AbstractReport> getSubReports() {
        return this.subReports;
    }

    private void loadUpCachedReports() throws JRException {
        this.cachedReport = this.loadReport();
        this.cachedSubReports = new ArrayList<JasperReport>();
        for (AbstractReport currentReport : this.getSubReports()) {
            JasperReport jasperSubRpt = currentReport.loadReport();
            this.cachedSubReports.add(jasperSubRpt);
        }
    }

    public JasperReport getJasperReport() {
        return this.cachedReport;
    }

    public void generate() throws JRException {
        if (this.cachedReport == null) {
            this.loadUpCachedReports();
        }
        for (JasperReport jasperSubRpt : this.cachedSubReports) {
            this.addReportParam(jasperSubRpt.getName(), jasperSubRpt);
        }
        this.viewer = null;
        this.print = this.runReport(this.cachedReport);
    }

    protected abstract JasperPrint runReport(JasperReport var1) throws JRException;

    public final JasperPrint getReport() {
        if (this.print == null) {
            throw new IllegalStateException("Cannot call getReport() until generate() it called");
        }
        return this.print;
    }

    public final JasperPrint addPagesToReport(JasperPrint printTo) {
        if (this.print == null) {
            throw new IllegalStateException("Cannot call addPagesToReport() until generate() it called");
        }
        if (printTo == null) {
            return this.getReport();
        }
        return this.addPagesToReport(printTo, this.print);
    }

    protected JasperPrint addPagesToReport(JasperPrint target, JasperPrint pagesToAdd) {
        for (JRPrintPage page : pagesToAdd.getPages()) {
            target.addPage(page);
        }
        return target;
    }

    public final synchronized JPanel getReportViewer() {
        if (this.print == null) {
            throw new IllegalStateException("Cannot call getReportViewer() until generate() it called");
        }
        if (this.viewer == null) {
            this.viewer = new JRViewer(this.print);
        }
        this.viewer.setFitWidthZoomRatio();
        return this.viewer;
    }

    public final void saveAsCSV(String saveFileName) throws Exception {
        if (this.print == null) {
            throw new IllegalStateException("Cannot call saveAsCSV() until generate() it called");
        }
        JRCsvExporter export = new JRCsvExporter();
        export.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.print);
        export.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)saveFileName);
        export.setParameter((JRExporterParameter)JRCsvExporterParameter.RECORD_DELIMITER, (Object)"\r\n");
        export.exportReport();
    }

    public final void saveAsCSV(Writer out) throws Exception {
        if (this.print == null) {
            throw new IllegalStateException("Cannot call saveAsCSV() until generate() is called");
        }
        JRCsvExporter export = new JRCsvExporter();
        export.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.print);
        export.setParameter(JRExporterParameter.OUTPUT_WRITER, (Object)out);
        export.exportReport();
    }
}

