/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.reports;

import au.com.ordermate.reports.AbstractReport;
import au.com.ordermate.reports.PrintData;
import au.com.ordermate.reports.ReportLoader;
import au.com.ordermate.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;

public abstract class PrintDataReport
extends AbstractReport {
    private Collection printData;

    public PrintDataReport(String newFileName, String property) {
        super(PrintDataReport.getReportFilePath(newFileName, property));
    }

    public Collection getPrintData() {
        return this.printData;
    }

    public void setPrintData(Collection newPrintData) {
        this.printData = newPrintData;
    }

    public void setPrintData(PrintData[] newPrintData) {
        this.setPrintData(Arrays.asList(newPrintData));
    }

    private static String getReportFilePath(String defaultVal, String property) {
        if (StringUtils.isEmpty(property)) {
            return defaultVal;
        }
        ReportProperty v = ReportProperty.find(ReportGroup.Config, property);
        if (!StringUtils.isEmpty(v.getValue())) {
            return v.getValue();
        }
        return defaultVal;
    }

    @Override
    protected JasperReport loadReport() throws JRException {
        return ReportLoader.loadReport(this.getClass(), this.getFileName());
    }

    public JRDataSource getDatasource() {
        return new JRBeanCollectionDataSource(this.printData);
    }

    @Override
    protected JasperPrint runReport(JasperReport report) throws JRException {
        JRBeanCollectionDataSource data = new JRBeanCollectionDataSource(this.printData);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, this.getReportParams(), (JRDataSource)data);
        return print;
    }
}

