/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.reports;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.compilers.JRGroovyCompiler;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import ordermate.OrderMate;

public class ReportLoader {
    private static JRGroovyCompiler groovyCompiler = new JRGroovyCompiler();

    public static JasperReport loadReport(Class relativeClassRef, String fileName) throws JRException {
        if (fileName.trim().isEmpty()) {
            throw new IllegalStateException("The report file name has not been set or is set to an empty value");
        }
        InputStream stream = ReportLoader.getFromJar(relativeClassRef, fileName);
        if (stream == null) {
            stream = ReportLoader.getFromFileSystem(fileName);
        }
        if (stream == null) {
            stream = ReportLoader.getFromURL(fileName);
        }
        if (stream == null) {
            stream = ReportLoader.getFromURL(fileName);
        }
        if (stream == null) {
            throw new IllegalArgumentException("Could not load report for : " + fileName);
        }
        JasperDesign jasperDesign = JRXmlLoader.load((InputStream)stream);
        return groovyCompiler.compileReport(jasperDesign);
    }

    private static InputStream getFromURL(String fileName) {
        try {
            return new URL(fileName).openStream();
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Could not get jrxml from URL : " + fileName);
            return null;
        }
    }

    private static InputStream getFromFileSystem(String fileName) {
        try {
            return new FileInputStream(fileName);
        }
        catch (Exception ex2) {
            OrderMate.LOG.warn("Could not get jrxml file from file system : " + fileName);
            return null;
        }
    }

    private static InputStream getFromJar(Class relativeClassRef, String filename) {
        try {
            return relativeClassRef.getResourceAsStream(filename);
        }
        catch (Exception ex1) {
            OrderMate.LOG.warn("Could not get jrxml file from JAR " + filename);
            return null;
        }
    }
}

