/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.abstracts;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.SearchFilterI;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractMultiplePropertySearchFilter
implements SearchFilterI {
    private PropertiedObject.Property[] properties;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public AbstractMultiplePropertySearchFilter(PropertiedObject.Property[] propertyJoinPath) {
        if (propertyJoinPath.length == 0) {
            throw new IllegalArgumentException("Cannot have empty property join path in a multi property search");
        }
        this.properties = propertyJoinPath;
    }

    protected PropertiedObject.Property[] getPropertyJoinPath() {
        return this.properties;
    }

    @Override
    public PropertiedObject.Property getProperty() {
        return this.properties[this.properties.length - 1];
    }

    @Override
    public void setProperty(PropertiedObject.Property prop) {
        PropertiedObject.Property orig = this.getProperty();
        if (!orig.getOwner().equals(prop.getOwner())) {
            throw new IllegalArgumentException("Cannot set search property to property with different owner");
        }
    }

    public void firePropertyChange(Object oldVal, Object newVal) {
        this.pcs.firePropertyChange("searchValue", oldVal, newVal);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public List<PropertiedObject.Property> getListOfPropertyJoinPath() {
        ArrayList<PropertiedObject.Property> joinPathProps = new ArrayList<PropertiedObject.Property>();
        joinPathProps.addAll(Arrays.asList(this.properties));
        return joinPathProps;
    }
}

