/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.abstracts;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.abstracts.AbstractSinglePropertySearchFilter;

public class RangeSearchFilter<T extends Comparable<T>>
extends AbstractSinglePropertySearchFilter
implements IRangedSearchFilter<T> {
    protected SQLDateType datetype = SQLDateType.TIMESTAMP;
    protected String havingAlias;
    protected T startRange;
    protected T endRange;

    public RangeSearchFilter(PropertiedObject.Property prop) {
        super(prop);
    }

    public RangeSearchFilter(PropertiedObject.Property prop, SQLDateType type) {
        super(prop);
        this.datetype = type;
    }

    @Override
    public IRangedSearchFilter<T> setStart(T newStartPoint) {
        this.startRange = newStartPoint;
        this.firePropertyChange(this.startRange, this.startRange);
        return this;
    }

    @Override
    public IRangedSearchFilter<T> setEnd(T newEndPoint) {
        this.endRange = newEndPoint;
        this.firePropertyChange(this.endRange, this.endRange);
        return this;
    }

    @Override
    public T getStart() {
        return this.startRange;
    }

    @Override
    public T getEnd() {
        return this.endRange;
    }

    @Override
    public void clearSearch() {
        this.startRange = null;
        this.endRange = null;
    }

    @Override
    public boolean hasSearchValue() {
        return this.startRange != null && this.endRange != null;
    }

    public String toString() {
        return "RangeFilter[" + this.getProperty() + " in " + this.startRange + "," + this.endRange + "]";
    }

    public void setHavingAlias(String value) {
        this.havingAlias = value;
    }
}

