/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.control;

import au.com.ordermate.gui.adminkit.AdminGuiUtils;
import au.com.ordermate.search.control.IDateRangePanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.Shift;
import ordermate.database.misc.TradingDay;
import org.jdesktop.swingx.JXDatePicker;

public class DateRangePanel
extends JPanel
implements IDateRangePanel {
    JXDatePicker startDatePicker = new JXDatePicker(Calendar.getInstance().getTime());
    JXDatePicker endDatePicker = new JXDatePicker(Calendar.getInstance().getTime());

    public DateRangePanel() {
        this(Calendar.getInstance(), Calendar.getInstance(), null, null);
    }

    public DateRangePanel(Calendar start, Calendar end, String customStartLabel, String customEndLabel) {
        super(new FlowLayout(10, 0, 0));
        this.startDatePicker = AdminGuiUtils.getInstance().standardDatePickerSetup(new JXDatePicker(start.getTime()));
        this.endDatePicker = AdminGuiUtils.getInstance().standardDatePickerSetup(new JXDatePicker(end.getTime()));
        JPanel startPanel = new JPanel();
        startPanel.add(new JLabel(customStartLabel != null ? customStartLabel : "Start date:"));
        startPanel.add((Component)this.startDatePicker);
        this.startDatePicker.setName("startDate");
        this.startDatePicker.getEditor().setName("startDateField");
        JPanel endPanel = new JPanel();
        endPanel.add(new JLabel(customEndLabel != null ? customEndLabel : "End date:"));
        endPanel.add((Component)this.endDatePicker);
        this.endDatePicker.setName("endDate");
        this.endDatePicker.getEditor().setName("endDateField");
        this.add(startPanel);
        this.add(endPanel);
    }

    @Override
    public void addAction(Action action) {
        if (action != null) {
            this.startDatePicker.addActionListener((ActionListener)action);
            this.endDatePicker.addActionListener((ActionListener)action);
        }
    }

    public TradingDay getStartTradingDay() {
        Shift shift = this.getStartShift();
        if (shift == null) {
            return null;
        }
        return shift.getTradingDay();
    }

    public TradingDay getEndTradingDay() {
        Shift shift = this.getEndShift();
        if (shift == null) {
            return null;
        }
        return shift.getTradingDay();
    }

    public Shift getStartShift() {
        return Shift.getFirstShiftForDate(this.startDatePicker.getDate());
    }

    public Shift getEndShift() {
        return Shift.getFirstShiftForDate(this.endDatePicker.getDate());
    }

    public Date getStartDate() {
        Date startDate = this.startDatePicker.getDate();
        if (startDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            return cal.getTime();
        }
        return null;
    }

    public Date getEndDate() {
        Date endDate = this.endDatePicker.getDate();
        if (endDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.endDatePicker.getDate());
            cal.add(5, 1);
            cal.add(13, -1);
            return cal.getTime();
        }
        return null;
    }

    public void setDates(Calendar start, Calendar end) {
        this.setDates(start.getTime(), end.getTime());
    }

    @Override
    public void setDates(Date startDate, Date endDate) {
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    public void setStartDate(Date start) {
        this.startDatePicker.setDate(start);
    }

    public void setEndDate(Date end) {
        this.endDatePicker.setDate(end);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getStartPicker().setEnabled(enabled);
        this.getEndPicker().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (this.getStartPicker() == null || this.getEndPicker() == null) {
            return false;
        }
        return this.getStartPicker().isEnabled() && this.getEndPicker().isEnabled();
    }

    public JXDatePicker getStartPicker() {
        return this.startDatePicker;
    }

    public JXDatePicker getEndPicker() {
        return this.endDatePicker;
    }

    @Override
    public void fireRefresh() {
        this.getStartPicker().cancelEdit();
    }
}

