/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.control;

import au.com.ordermate.gui.ObjectEditedDespatch;
import au.com.ordermate.gui.ObjectEditedListener;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.search.control.IDateRangePanel;
import au.com.ordermate.search.filter.FixedPeriod;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import ordermate.database.misc.DayPart;
import ordermate.gui.model.NullableEventComboBoxModel;

public class FixedPeriodsPanel
extends JPanel
implements ActionListener,
ObjectEditedListener {
    private String NULL_PLACEHOLDER = "<Custom>";
    private IDateRangePanel rangePanel;
    private JComboBox datesCombo;
    private NullableEventComboBoxModel model;
    private final EventList<FixedPeriod> datesList = new BasicEventList();
    private boolean changing = false;

    public FixedPeriodsPanel(IDateRangePanel yourPanel) {
        if (yourPanel == null) {
            throw new IllegalArgumentException("Cannot have a Fixed Period Panel withour a DateRangePanel");
        }
        this.rangePanel = yourPanel;
        this.setupComponents();
        ObjectEditedDespatch.getInstance().addListener(DayPart.class, this);
        this.rangePanel.addAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FixedPeriodsPanel.this.changing) {
                    FixedPeriodsPanel.this.reset();
                }
            }
        });
    }

    private void setupComponents() {
        this.model = new NullableEventComboBoxModel(this.datesList, this.NULL_PLACEHOLDER);
        this.refreshList();
        this.datesCombo = new JComboBox(this.model);
        this.datesCombo.setSelectedItem(this.NULL_PLACEHOLDER);
        this.datesCombo.addActionListener(this);
        ComponentUtils.setupComboBox(this.datesCombo);
        this.add(this.datesCombo);
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.datesCombo.setEnabled(value);
    }

    private void refreshList() {
        try {
            this.datesList.getReadWriteLock().writeLock().lock();
            this.datesList.clear();
            this.datesList.addAll(FixedPeriod.getDefaultFixedPeriods());
            if (this.datesList.size() == 0) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
                this.model.prependNullPlaceholder(this.datesList);
                this.model.setSelectedItem(null);
            }
        }
        finally {
            this.datesList.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.datesCombo && this.datesCombo.getSelectedItem() != null) {
            this.changing = true;
            FixedPeriod date = (FixedPeriod)this.model.getSelectedItem();
            if (date != null) {
                this.rangePanel.setDates(date.getStartDate(), date.getEndDate());
                this.rangePanel.fireRefresh();
            }
            this.changing = false;
        }
    }

    public void reset() {
        this.changing = true;
        this.datesCombo.setSelectedItem(null);
        this.changing = false;
    }

    @Override
    public void objectEdited(Class clazz) {
        if (DayPart.class.equals((Object)clazz)) {
            this.datesCombo.removeActionListener(this);
            this.refreshList();
            this.datesCombo.addActionListener(this);
        }
    }

    public DayPart getSelectedDayPart() {
        return (DayPart)this.datesCombo.getSelectedItem();
    }
}

