/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.filter;

import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class FixedPeriod {
    private static List<FixedPeriod> defaultList;
    private static List<FixedPeriod> futureList;
    private String label;
    private String prefix;

    public static final synchronized FixedPeriod getDefaultFixedPeriodForLabel(String label) {
        return FixedPeriod.findFixedPeriod(FixedPeriod.getDefaultFixedPeriods(), label);
    }

    public static final synchronized List<FixedPeriod> getDefaultFixedPeriods() {
        if (defaultList == null) {
            FixedPeriod.createList();
        }
        return defaultList;
    }

    private static void createList() {
        defaultList = new ArrayList<FixedPeriod>();
        defaultList.add(new Today());
        defaultList.add(new Yesterday());
        defaultList.add(new WeekToDate());
        defaultList.add(new LastSevenDays());
        defaultList.add(new MonthToDate());
        defaultList.add(new LastWeek());
        defaultList.add(new LastMonth());
    }

    public static final synchronized FixedPeriod getDefaultFuturePeriodForLabel(String label) {
        return FixedPeriod.findFixedPeriod(FixedPeriod.getDefaultFuturePeriods(), label);
    }

    public static final synchronized List<FixedPeriod> getDefaultFuturePeriods() {
        if (futureList == null) {
            FixedPeriod.createFutureList();
        }
        return futureList;
    }

    private static void createFutureList() {
        futureList = new ArrayList<FixedPeriod>();
        futureList.add(new Today().appendPrefix("Due"));
        futureList.add(new Tomorrow().appendPrefix("Due"));
        futureList.add(new ThisWeek().appendPrefix("Due"));
        futureList.add(new NextWeek().appendPrefix("Due"));
        futureList.add(new ThisMonth().appendPrefix("Due"));
        futureList.add(new NextMonth().appendPrefix("Due"));
    }

    private static FixedPeriod findFixedPeriod(List<FixedPeriod> periods, String label) {
        for (FixedPeriod period : FixedPeriod.getDefaultFixedPeriods()) {
            if (!period.getLabel().equals(label)) continue;
            return period;
        }
        return null;
    }

    public FixedPeriod(String yourLabel) {
        this.label = yourLabel;
        if (this.label == null) {
            throw new IllegalArgumentException("Cannot have a nuill Fixed Period label");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix).append(" ");
        }
        sb.append(this.label);
        return sb.toString();
    }

    public Date getStartDate() {
        return this.getStartDate(new Date());
    }

    public abstract Date getStartDate(Date var1);

    public Date getEndDate() {
        return this.getEndDate(new Date());
    }

    public abstract Date getEndDate(Date var1);

    public String getLabel() {
        return this.label;
    }

    public FixedPeriod appendPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    static class NextMonth
    extends FixedPeriod {
        NextMonth() {
            super("Next Month");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.setTime(this.getEndDate());
            cal.set(5, cal.getActualMinimum(5));
            return DateTimeUtils.getStartOfMonth(cal.getTime()).getTime();
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.add(2, 1);
            return DateTimeUtils.getEndOfMonth(cal.getTime()).getTime();
        }
    }

    static class ThisMonth
    extends FixedPeriod {
        ThisMonth() {
            super("This Month");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.setTime(this.getEndDate());
            cal.set(5, cal.getActualMinimum(5));
            return DateTimeUtils.getStartOfMonth(cal.getTime()).getTime();
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            return DateTimeUtils.getEndOfMonth(cal.getTime()).getTime();
        }
    }

    static class NextWeek
    extends FixedPeriod {
        NextWeek() {
            super("Next Week");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            return DateTimeUtils.getStartDateForWeek(this.getEndDate(referenceDate));
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.add(3, 1);
            return DateTimeUtils.getEndDateForWeek(cal.getTime());
        }
    }

    static class ThisWeek
    extends FixedPeriod {
        ThisWeek() {
            super("This Week");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            return DateTimeUtils.getStartDateForWeek(this.getEndDate(referenceDate));
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            return DateTimeUtils.getEndDateForWeek(cal.getTime());
        }
    }

    static class Tomorrow
    extends FixedPeriod {
        Tomorrow() {
            super("Tomorrow");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            return DateTimeUtils.getStartOfDay(this.getEndDate(referenceDate));
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.add(5, 1);
            return DateTimeUtils.getEndOfDay(cal.getTime());
        }
    }

    static class LastMonth
    extends FixedPeriod {
        LastMonth() {
            super("Last Month");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.set(5, 1);
            cal.add(2, -1);
            cal.set(5, cal.getActualMinimum(5));
            return DateTimeUtils.getStartOfDay(cal.getTime());
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.set(5, 1);
            cal.add(2, -1);
            cal.set(5, cal.getActualMaximum(5));
            return DateTimeUtils.getEndOfDay(cal.getTime());
        }
    }

    static class MonthToDate
    extends FixedPeriod {
        MonthToDate() {
            super("Month To Date");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.set(5, cal.getActualMinimum(5));
            return DateTimeUtils.getStartOfDay(cal.getTime());
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            return DateTimeUtils.getEndOfDay(referenceDate);
        }
    }

    static class LastWeek
    extends FixedPeriod {
        LastWeek() {
            super("Last Week");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.add(7, -7);
            return DateTimeUtils.getStartDateForWeek(cal.getTime());
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            return DateTimeUtils.getEndDateForWeek(this.getStartDate(referenceDate));
        }
    }

    static class LastSevenDays
    extends FixedPeriod {
        LastSevenDays() {
            super("Last Seven Days");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.add(5, -7);
            return DateTimeUtils.getStartOfDay(cal.getTime());
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            return DateTimeUtils.getEndOfDay(referenceDate);
        }
    }

    static class WeekToDate
    extends FixedPeriod {
        WeekToDate() {
            super("Week To Date");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            return DateTimeUtils.getStartDateForWeek(referenceDate);
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            return DateTimeUtils.getEndOfDay(referenceDate);
        }
    }

    static class Yesterday
    extends FixedPeriod {
        Yesterday() {
            super("Yesterday");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            return DateTimeUtils.getStartOfDay(this.getEndDate(referenceDate));
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            Calendar cal = DateTimeUtils.toCal(referenceDate);
            cal.add(5, -1);
            return DateTimeUtils.getEndOfDay(cal.getTime());
        }
    }

    static class Today
    extends FixedPeriod {
        Today() {
            super("Today");
        }

        @Override
        public Date getStartDate(Date referenceDate) {
            return DateTimeUtils.getStartOfDay(referenceDate);
        }

        @Override
        public Date getEndDate(Date referenceDate) {
            return DateTimeUtils.getEndOfDay(referenceDate);
        }
    }
}

