/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.offset;

import au.com.ordermate.search.offset.DateOffsetFunction;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public abstract class AbstractDateOffsetFunction
implements DateOffsetFunction,
Serializable {
    protected final int field;
    protected final int offsetAmount;

    public AbstractDateOffsetFunction(int calendarField, int amount) {
        this.field = calendarField;
        this.offsetAmount = amount;
    }

    protected abstract Calendar calcStart(Calendar var1);

    @Override
    public Date calcStart(Date pointWithinRange) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(pointWithinRange);
        return this.calcStart(cal).getTime();
    }

    @Override
    public Calendar calcOffset(Calendar cal) {
        Calendar newCal = Calendar.getInstance();
        newCal.setTime(this.calculateOffset(cal.getTime()));
        return newCal;
    }

    @Override
    public Date calcOffset(Date original) {
        return this.calculateOffset(original);
    }

    protected Date calculateOffset(Date original) {
        if (original == null) {
            return null;
        }
        Date origDate = original;
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(origDate);
        startCal.add(this.field, this.offsetAmount);
        return startCal.getTime();
    }

    @Override
    public Date calcReverseOffset(Date original) {
        return this.calculateReverse(original);
    }

    protected Date calculateReverse(Date original) {
        if (original == null) {
            return null;
        }
        Date origDate = original;
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(origDate);
        startCal.add(this.field, -this.offsetAmount);
        return startCal.getTime();
    }

    public boolean isBackwards() {
        return this.offsetAmount < 0;
    }

    protected Calendar calcEnd(Calendar dateWithinPeriod) {
        Calendar start = this.calcStart((Calendar)dateWithinPeriod.clone());
        Calendar startNext = this.calcOffset(start);
        int direction = this.isBackwards() ? 86399999 : 1;
        startNext.add(14, -direction);
        return startNext;
    }

    @Override
    public Date calcEnd(Date pointWithinRange) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(pointWithinRange);
        return this.calcEnd(cal).getTime();
    }
}

