/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.offset;

import au.com.ordermate.search.offset.AbstractDateOffsetFunction;
import au.com.ordermate.search.offset.DateOffsetEndAdapter;
import au.com.ordermate.search.offset.DateOffsetFunction;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.HashSet;

public class DateOffsetFunctions {
    public static final AbstractDateOffsetFunction NONE = new AbstractDateOffsetFunction(5, 0){

        @Override
        public Calendar calcStart(Calendar pointWithinRange) {
            Calendar result = (Calendar)pointWithinRange.clone();
            DateTimeUtils.clearTimePart(result);
            return result;
        }

        public String toString() {
            return "None";
        }
    };
    public static final AbstractDateOffsetFunction NEXT_DAY = new AbstractDateOffsetFunction(5, 1){

        @Override
        public Calendar calcStart(Calendar pointWithinRange) {
            Calendar result = (Calendar)pointWithinRange.clone();
            DateTimeUtils.clearTimePart(result);
            return result;
        }

        public String toString() {
            return "Day";
        }
    };
    public static final AbstractDateOffsetFunction NEXT_MONTH = new AbstractDateOffsetFunction(2, 1){

        @Override
        public Calendar calcStart(Calendar pointWithinRange) {
            while (pointWithinRange.get(5) != 1) {
                pointWithinRange.add(5, -1);
            }
            DateTimeUtils.clearTimePart(pointWithinRange);
            return pointWithinRange;
        }

        public String toString() {
            return "Month";
        }
    };
    public static final AbstractDateOffsetFunction NEXT_WEEK_ENDING = new AbstractDateOffsetFunction(5, -6){

        @Override
        public Calendar calcStart(Calendar pointWithinRange) {
            while (pointWithinRange.get(7) != 1) {
                pointWithinRange.add(7, 1);
            }
            DateTimeUtils.lastMillisecond(pointWithinRange);
            return pointWithinRange;
        }

        @Override
        protected Calendar calcEnd(Calendar dateWithinPeriod) {
            Calendar cal = super.calcEnd(dateWithinPeriod);
            DateTimeUtils.clearTimePart(cal);
            return cal;
        }

        public String toString() {
            return "Week Ending";
        }
    };
    public static final AbstractDateOffsetFunction NEXT_QUARTER = new AbstractDateOffsetFunction(2, 3){

        @Override
        public Calendar calcStart(Calendar pointWithinRange) {
            HashSet<Integer> qtrSet = new HashSet<Integer>(){
                {
                    this.add(0);
                    this.add(3);
                    this.add(6);
                    this.add(9);
                }
            };
            pointWithinRange.set(5, 1);
            while (!qtrSet.contains(pointWithinRange.get(2))) {
                pointWithinRange.add(2, -1);
            }
            DateTimeUtils.clearTimePart(pointWithinRange);
            return pointWithinRange;
        }

        public String toString() {
            return "Quarter";
        }
    };
    public static final AbstractDateOffsetFunction NEXT_YEAR = new AbstractDateOffsetFunction(1, 1){

        @Override
        public Calendar calcStart(Calendar pointWithinRange) {
            while (pointWithinRange.get(6) != 1) {
                pointWithinRange.add(6, -1);
            }
            DateTimeUtils.clearTimePart(pointWithinRange);
            return pointWithinRange;
        }

        public String toString() {
            return "Year";
        }
    };
    public static final DateOffsetFunction END_DAY = new DateOffsetEndAdapter(NEXT_DAY);
    public static final DateOffsetFunction END_WEEK_ENDING = new DateOffsetEndAdapter(NEXT_WEEK_ENDING){

        @Override
        protected Calendar calcEnd(Calendar dateWithinPeriod) {
            Calendar cal = super.calcEnd(dateWithinPeriod);
            DateTimeUtils.clearTimePart(cal);
            return cal;
        }
    };
    public static final DateOffsetFunction END_MONTH = new DateOffsetEndAdapter(NEXT_MONTH);
    public static final DateOffsetFunction END_QUARTER = new DateOffsetEndAdapter(NEXT_QUARTER);
    public static final DateOffsetFunction END_YEAR = new DateOffsetEndAdapter(NEXT_YEAR);
}

