/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.pager;

import au.com.ordermate.search.pager.Pager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class PagerModel
implements Pager {
    private int currentPageIndex = 0;
    private int listSize = 0;
    private int elementsPerPage;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROP_LIST_SIZE = "listSize";
    public static final String PROP_PAGE_INDEX = "pageIndex";
    private static final int DEFAULT_ELEM_PER_PAGE = 1000;

    public PagerModel() {
        this(1000);
    }

    public PagerModel(int itemsPerPage) {
        this.elementsPerPage = itemsPerPage;
    }

    @Override
    public int getPageIndex() {
        return this.currentPageIndex;
    }

    @Override
    public boolean hasMorePages() {
        return this.getPageIndex() + 1 < this.getNumPages();
    }

    @Override
    public boolean hasPreviousPages() {
        return this.getPageIndex() > 0;
    }

    @Override
    public void setListSize(int numElements) {
        int previousSize = this.listSize;
        this.listSize = numElements;
        this.pcs.firePropertyChange(PROP_LIST_SIZE, previousSize, this.listSize);
        if (this.listSize > 0 && this.currentPageIndex > this.getNumPages()) {
            this.setPageIndex(0);
        }
    }

    @Override
    public int getListSize() {
        return this.listSize;
    }

    @Override
    public int getNumPages() {
        return (int)Math.ceil((double)this.listSize / (double)this.getElementsPerPage());
    }

    @Override
    public int getElementsPerPage() {
        return this.elementsPerPage;
    }

    public void setPageIndex(int index) {
        if (index >= 0 && index < this.getNumPages()) {
            int prevValue = this.currentPageIndex;
            this.currentPageIndex = index;
            this.pcs.firePropertyChange(PROP_PAGE_INDEX, prevValue, this.currentPageIndex);
        } else {
            if (this.isPaged()) {
                throw new IndexOutOfBoundsException("Index must zero or greater and less than numPages: " + this.getNumPages() + ", index: " + index);
            }
            int prevValue = this.currentPageIndex;
            this.currentPageIndex = 0;
            this.pcs.firePropertyChange(PROP_PAGE_INDEX, prevValue, this.currentPageIndex);
        }
    }

    public void next() {
        if (!this.hasMorePages()) {
            throw new IllegalStateException("No more pages");
        }
        this.setPageIndex(this.currentPageIndex + 1);
    }

    public void previous() {
        if (!this.hasPreviousPages()) {
            throw new IllegalStateException("No previous pages");
        }
        this.setPageIndex(this.currentPageIndex - 1);
    }

    public boolean hasPage(int pageNumber) {
        return pageNumber > 0 && pageNumber <= this.getNumPages();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void setElementsPerPage(int value) {
        this.elementsPerPage = value;
    }

    @Override
    public boolean isPaged() {
        return this.elementsPerPage > 0;
    }
}

