/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.gui.adminkit.AdminGuiUtils;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.gui.renderer.FormatListCellRenderer;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.text.Format;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;

public abstract class AbstractComboSearchField
extends SearchGuiField {
    private JComboBox comboBox = new JComboBox();
    private EventComboBoxModel model;
    private EventList listData;
    private int defaultValueIndex = 0;

    public AbstractComboSearchField(String searchFieldLabel, Action refreshAction, EventList dataList, Format formatter) {
        this(searchFieldLabel, refreshAction, formatter);
        this.setListData(dataList);
    }

    public AbstractComboSearchField(String searchFieldLabel, Action refreshAction, Format formatter) {
        super(searchFieldLabel, null);
        this.comboBox.setName(searchFieldLabel);
        AdminGuiUtils.getInstance().standardComboSetup(this.comboBox);
        ComponentUtils.setupComboBox(this.comboBox);
        if (formatter != null) {
            this.setFormat(formatter);
        }
        this.addAction(refreshAction);
    }

    public void setListData(EventList data) {
        this.model = new EventComboBoxModel(data);
        this.comboBox.setModel(this.model);
        this.listData = data;
    }

    public EventList getListData() {
        return this.listData;
    }

    protected EventComboBoxModel getModel() {
        return this.model;
    }

    @Override
    public JComboBox getGuiComponent() {
        return this.getComboBox();
    }

    @Override
    public void reset() {
        if (this.model.getSize() > 0) {
            this.getComboBox().setSelectedIndex(this.defaultValueIndex);
        }
    }

    public AbstractComboSearchField setRenderer(ListCellRenderer renderer) {
        this.getComboBox().setRenderer(renderer);
        return this;
    }

    public AbstractComboSearchField setFormat(Format format) {
        this.comboBox.setRenderer(new FormatListCellRenderer(format));
        this.comboBox.setEditable(false);
        return this;
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    @Override
    public void addAction(Action action) {
        if (action != null) {
            this.getComboBox().addActionListener(action);
        }
    }

    public void setDefaultValueIndex(int defaultValueIndex) {
        this.defaultValueIndex = defaultValueIndex;
    }
}

