/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.oquery.search.filter.implementation.BooleanQueryFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import au.com.ordermate.search.filter.implementation.BooleanEventListFilter;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.SearchType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JCheckBox;

public class CheckBoxSearchField
extends SearchGuiField {
    private final JCheckBox check = new JCheckBox();
    private final BooleanSearchFilter searchProp;
    private Object comparisonValue = 1;
    boolean invertNot = false;
    private boolean filterWhenOff = true;

    public CheckBoxSearchField(String searchFieldlabel, PropertiedObject.Property newSearchProp, Action onCheck) {
        this(searchFieldlabel, SearchType.QUERY_RESTRICTION, newSearchProp, onCheck);
    }

    public CheckBoxSearchField(String searchFieldLabel, SearchType type, PropertiedObject.Property newSearchProp, Action onCheck) {
        this(searchFieldLabel, CheckBoxSearchField.createBooleanSearchFilter(type, newSearchProp), onCheck);
    }

    public CheckBoxSearchField(String searchFieldLabel, BooleanSearchFilter filter, Action onCheck) {
        super(searchFieldLabel, null);
        this.searchProp = filter;
        this.sync();
        this.addAction(onCheck);
        this.check.setName("chkOnlyUnlinked");
        this.check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckBoxSearchField.this.sync();
            }
        });
    }

    private static final BooleanSearchFilter createBooleanSearchFilter(SearchType type, PropertiedObject.Property prop) {
        if (SearchType.QUERY_RESTRICTION.equals((Object)type)) {
            return new BooleanQueryFilter(prop);
        }
        if (SearchType.EVENTLIST_FILTER.equals((Object)type)) {
            return new BooleanEventListFilter(prop);
        }
        throw new IllegalArgumentException("Unimplemented search type : " + (Object)((Object)type));
    }

    private void sync() {
        if (!this.isEnabled()) {
            this.searchProp.setSearchValue(null);
        } else if (this.check.isSelected()) {
            this.searchProp.setNot(this.invertNot);
            this.searchProp.setSearchValue(this.comparisonValue);
        } else if (this.filterWhenOff) {
            this.searchProp.setNot(!this.invertNot);
            this.searchProp.setSearchValue(this.comparisonValue);
        } else {
            this.searchProp.setSearchValue(null);
        }
    }

    @Override
    public void addAction(Action action) {
        if (action != null) {
            this.check.addActionListener(action);
        }
    }

    @Override
    public Component getGuiComponent() {
        return this.check;
    }

    public CheckBoxSearchField filterWhenDeselected(boolean filter) {
        this.filterWhenOff = filter;
        this.sync();
        return this;
    }

    public CheckBoxSearchField setComparisonValue(Object value) {
        this.comparisonValue = value;
        this.sync();
        return this;
    }

    @Override
    public SearchFilterI getSearchProperty() {
        return this.searchProp;
    }

    public CheckBoxSearchField not() {
        this.invertNot = true;
        this.sync();
        return this;
    }

    @Override
    public void reset() {
        this.check.setSelected(false);
        this.sync();
    }

    @Override
    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
    }

    @Override
    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

