/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.filter.implementation.BooleanEventListFilter;
import au.com.ordermate.search.searchfield.java.AbstractComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchType;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CompositeList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import ordermate.OrderMate;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class ComboSearchField
extends AbstractComboSearchField
implements ListDataListener {
    private final ISingleValueSearchFilter searchFilter;
    private final boolean allowAnyType;
    private String anyValue = "Any";
    private EventList anyList;

    public ComboSearchField(String searchFieldLabel, PropertiedObject.Property searchProp, SearchType searchType, boolean allowAnyOption, Action action, Set staticData) {
        this(searchFieldLabel, searchProp, searchType, allowAnyOption, action, GlazedLists.eventList((Collection)staticData));
    }

    public ComboSearchField(String searchFieldLabel, PropertiedObject.Property searchProp, boolean allowAnyOption, Action action, EventList dynamicData) {
        this(searchFieldLabel, searchProp, SearchType.QUERY_RESTRICTION, allowAnyOption, action, dynamicData);
    }

    public ComboSearchField(String searchFieldLabel, PropertiedObject.Property searchProp, SearchType searchType, boolean allowAnyOption, Action action, EventList dynamicData) {
        this(searchFieldLabel, ComboSearchField.createFilter(searchType, searchProp), allowAnyOption, action, dynamicData);
    }

    private static ISingleValueSearchFilter createFilter(SearchType type, PropertiedObject.Property prop) {
        switch (type) {
            case QUERY_RESTRICTION: {
                return new ObjectSearchFilter(prop);
            }
            case EVENTLIST_FILTER: {
                return new BooleanEventListFilter(prop);
            }
        }
        throw new IllegalArgumentException("Unimplemented search type : " + (Object)((Object)type));
    }

    public ComboSearchField(String searchFieldLabel, ISingleValueSearchFilter search, boolean allowAnyOption, Action action, EventList dynamicData) {
        this(searchFieldLabel, search, allowAnyOption, action, dynamicData, null);
    }

    public ComboSearchField(String searchFieldLabel, ISingleValueSearchFilter search, boolean allowAnyOption, Action action, EventList dynamicData, Format formatter) {
        super(searchFieldLabel, action, formatter);
        if (action == null) {
            action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboSearchField.this.setSearchValue(ComboSearchField.this.getSelectedObject());
                }
            };
            action.setEnabled(false);
            this.addAction(action);
        }
        boolean oldEnable = action.isEnabled();
        action.setEnabled(false);
        this.searchFilter = search;
        this.allowAnyType = allowAnyOption;
        this.setListData(dynamicData);
        EventList listData = this.getListData();
        this.getComboBox().getModel().addListDataListener(this);
        if (!listData.isEmpty()) {
            this.setSelectedObject(listData.get(0));
        }
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.getComboBox(), (Property)BeanProperty.create((String)"selectedItem"), (Object)this, (Property)BeanProperty.create((String)"searchValue"));
        binding.bind();
        action.setEnabled(oldEnable);
    }

    public ComboSearchField setAnyHolder(String holder) {
        if (this.anyList != null) {
            int index = this.anyList.indexOf((Object)this.anyValue);
            this.anyList.remove((Object)this.anyValue);
            if (index >= 0) {
                this.anyList.add(index, (Object)holder);
            }
        }
        this.anyValue = holder;
        return this;
    }

    @Override
    public SearchFilterI getSearchProperty() {
        return this.searchFilter;
    }

    public Object getSelectedObject() {
        return this.getComboBox().getSelectedItem();
    }

    public void setSelectedObject(Object obj) {
        this.getComboBox().setSelectedItem(obj);
    }

    public void setSearchValue(Object value) {
        if (this.searchFilter == null) {
            OrderMate.LOG.warn("No search Property");
            return;
        }
        if (!this.isEnabled()) {
            this.searchFilter.clearSearch();
            return;
        }
        if (value == null) {
            if (this.allowAnyType) {
                this.searchFilter.setSearchValue(null);
            } else if (this.getComboBox().getModel().getSize() > 0) {
                this.setSelectedObject(this.getComboBox().getModel().getElementAt(0));
            }
        } else if (this.anyValue.equalsIgnoreCase(value.toString()) && value instanceof String) {
            this.searchFilter.setSearchValue(null);
        } else {
            this.searchFilter.setSearchValue(value);
        }
    }

    @Override
    public void setListData(EventList data) {
        CompositeList dataList = new CompositeList(data.getPublisher(), data.getReadWriteLock());
        if (this.allowAnyType) {
            this.anyList = new BasicEventList(data.getPublisher(), data.getReadWriteLock());
            this.anyList.add(0, (Object)this.anyValue);
            dataList.addMemberList(this.anyList);
        }
        dataList.addMemberList(data);
        super.setListData((EventList)dataList);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (this.getComboBox().getSelectedItem() == null && this.getComboBox().getModel().getSize() > 0) {
            this.setSelectedObject(this.getComboBox().getModel().getElementAt(0));
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
        if (!flag && this.searchFilter != null) {
            this.searchFilter.clearSearch();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

