/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.gui.adminkit.AdminGuiUtils;
import au.com.ordermate.oquery.search.filter.implementation.CustomerTenureSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CustomerTenureSearchField
extends SearchGuiField
implements ActionListener,
ChangeListener {
    private JPanel tenureFieldPanel = new JPanel(new FlowLayout());
    private JSpinner timeLengthSpinner;
    private JComboBox lengthTypeComboBox;
    private EventComboBoxModel lengthTypeModel;
    private static final int SPINNER_MODEL_MIN = 1;
    private static final int SPINNER_MODEL_MAX = 1500;
    private CustomerTenureSearchFilter searchFilter;

    public CustomerTenureSearchField(String searchFieldLabel, CustomerTenureSearchFilter searchProperty, Action refreshAction, Format formatter, EventList dataList) {
        super(searchFieldLabel, refreshAction);
        this.tenureFieldPanel.setName(searchFieldLabel);
        this.timeLengthSpinner = new JSpinner();
        this.timeLengthSpinner.setName(searchFieldLabel + "TimeLengthSpinner");
        AdminGuiUtils.getInstance().standardSpinnerSetup(this.timeLengthSpinner);
        this.lengthTypeComboBox = new JComboBox();
        this.lengthTypeComboBox.setName(searchFieldLabel + "LengthTypeComboBox");
        if (formatter != null) {
            this.lengthTypeComboBox.setRenderer(this.createRenderer(formatter));
            this.lengthTypeComboBox.setEditable(false);
        }
        JPanel timeLengthSpinnerPanel = new JPanel();
        timeLengthSpinnerPanel.add(this.timeLengthSpinner);
        this.tenureFieldPanel.add(timeLengthSpinnerPanel);
        this.tenureFieldPanel.add(this.lengthTypeComboBox);
        this.addAction(refreshAction);
        this.searchFilter = searchProperty;
        this.setRangeTypeComboListData(dataList);
        this.timeLengthSpinner.setModel(new SpinnerNumberModel(1, 1, 1500, 1));
        this.lengthTypeComboBox.setSelectedIndex(0);
        this.lengthTypeComboBox.addActionListener(this);
        this.timeLengthSpinner.addChangeListener(this);
    }

    public CustomerTenureSearchField(String searchFieldLabel, CustomerTenureSearchFilter searchProperty, Action refreshAction, EventList dataList) {
        this(searchFieldLabel, searchProperty, refreshAction, null, dataList);
    }

    public void setRangeTypeComboListData(EventList data) {
        this.lengthTypeModel = new EventComboBoxModel(data);
        this.lengthTypeComboBox.setModel(this.lengthTypeModel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.lengthTypeComboBox) {
            this.searchFilter.setRangeType((CustomerTenureSearchFilter.UnitOfTime)((Object)this.lengthTypeComboBox.getSelectedItem()));
        }
    }

    @Override
    public Component getGuiComponent() {
        return this.tenureFieldPanel;
    }

    @Override
    public void addAction(Action action) {
    }

    @Override
    public void reset() {
        if (this.lengthTypeModel.getSize() > 0) {
            this.getLengthTypeComboBox().setSelectedIndex(0);
        }
        this.getTimeLengthSpinner().setValue(1);
    }

    @Override
    public SearchFilterI getSearchProperty() {
        return this.searchFilter;
    }

    @Override
    public void setVisible(boolean flag) {
        this.lengthTypeComboBox.setVisible(flag);
        this.timeLengthSpinner.setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.lengthTypeComboBox.isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.lengthTypeComboBox.setEnabled(flag);
        this.timeLengthSpinner.setEnabled(flag);
        if (!flag) {
            this.searchFilter.clearSearch();
        } else {
            this.searchFilter.setRangeValue((Integer)this.timeLengthSpinner.getValue());
            this.searchFilter.setRangeType((CustomerTenureSearchFilter.UnitOfTime)((Object)this.lengthTypeComboBox.getSelectedItem()));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.lengthTypeComboBox.isEnabled();
    }

    private ListCellRenderer createRenderer(final Format formatter) {
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                comp.setText(value == null ? null : formatter.format(value));
                return comp;
            }
        };
        return renderer;
    }

    protected JComboBox getLengthTypeComboBox() {
        return this.lengthTypeComboBox;
    }

    protected JSpinner getTimeLengthSpinner() {
        return this.timeLengthSpinner;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.timeLengthSpinner) {
            int spinnerValue = (Integer)this.timeLengthSpinner.getValue();
            this.searchFilter.setRangeValue(spinnerValue);
        }
    }
}

