/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.DateRangePanel;
import au.com.ordermate.search.control.FixedPeriodsPanel;
import au.com.ordermate.search.searchfield.java.AbstractDateRangeSearchField;
import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Action;
import javax.swing.JPanel;

public class DateRangeSearchField
extends AbstractDateRangeSearchField
implements PropertyChangeListener {
    boolean updating = false;
    private JPanel holder;
    private DateRangePanel dateRangePanel;
    private FixedPeriodsPanel fixedDatesPanel;

    public DateRangeSearchField(String label, PropertiedObject.Property prop, Date startSearchDate, SQLDateType dateType) {
        this(label, prop, startSearchDate, null, dateType);
    }

    public DateRangeSearchField(String label, PropertiedObject.Property prop, Date startSearchDate, Action refreshAction, SQLDateType dateType) {
        this(label, new DateRangeSearchFilter(prop, dateType), startSearchDate, refreshAction);
    }

    public DateRangeSearchField(String label, IRangedQuerySearchFilter<Date> prop, Date startSearchDate, Action refreshAction) {
        this(label, prop, startSearchDate, refreshAction, null);
    }

    public DateRangeSearchField(String label, IRangedQuerySearchFilter<Date> prop, Date startSearchDate, Action refreshAction, DateRangePanel dateRangePanel) {
        super(label, prop, refreshAction);
        Date start;
        this.dateRangePanel = dateRangePanel;
        prop.addPropertyChangeListener(this);
        Date date = start = prop.getStart() != null ? (Date)prop.getStart() : startSearchDate;
        if (startSearchDate == null) {
            GregorianCalendar startCal = new GregorianCalendar();
            startCal.set(11, 0);
            startCal.set(12, 0);
            startCal.set(13, 0);
            startCal.set(14, 0);
            start = startCal.getTime();
        }
        this.getDateRangePanel().setDates(start, prop.getEnd() != null ? (Date)prop.getEnd() : new Date());
        this.getDateRangePanel().addAction(refreshAction);
    }

    public DateRangeSearchField(String label, PropertiedObject.Property prop, SQLDateType dateType) {
        this(label, prop, null, null, dateType);
    }

    public DateRangeSearchField(String label, PropertiedObject.Property prop, Action refreshAction, SQLDateType dateType) {
        this(label, prop, null, refreshAction, dateType);
    }

    public DateRangeSearchField useFixedDates() {
        this.holder = new JPanel(new FlowLayout(0));
        this.holder.add(this.getDateRangePanel());
        this.holder.add(this.getFixedDatesPanel());
        return this;
    }

    @Override
    public Component getGuiComponent() {
        if (this.holder != null) {
            return this.holder;
        }
        return this.getDateRangePanel();
    }

    @Override
    public void addAction(Action action) {
        this.getDateRangePanel().addAction(action);
    }

    @Override
    public void reset() {
        this.getDateRangePanel().setEndDate(new Date());
        GregorianCalendar today = new GregorianCalendar();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        this.getDateRangePanel().setStartDate(today.getTime());
    }

    public DateRangePanel getDateRangePanel() {
        if (this.dateRangePanel == null) {
            this.dateRangePanel = new DateRangePanel();
        }
        return this.dateRangePanel;
    }

    private FixedPeriodsPanel getFixedDatesPanel() {
        if (this.fixedDatesPanel == null) {
            this.fixedDatesPanel = new FixedPeriodsPanel(this.getDateRangePanel());
        }
        return this.fixedDatesPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public IRangedSearchFilter<Date> getSearchProperty() {
        try {
            this.updating = true;
            SearchFilterI searchProp = super.getSearchProperty();
            if (this.isEnabled()) {
                searchProp.setStart(this.getDateRangePanel().getStartDate());
                searchProp.setEnd(this.getDateRangePanel().getEndDate());
            } else {
                searchProp.setStart(null);
                searchProp.setEnd(null);
            }
            SearchFilterI searchFilterI = searchProp;
            return searchFilterI;
        }
        finally {
            this.updating = false;
        }
    }

    @Override
    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        if (this.holder != null) {
            this.holder.setEnabled(flag);
            this.fixedDatesPanel.setEnabled(flag);
        } else {
            this.getDateRangePanel().setEnabled(flag);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

