/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.oquery.search.filter.implementation.ComparisonSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DaysAgoSearchField
extends SearchGuiField {
    private final ISingleValueSearchFilter<Date> comparisonFilter;
    private final JPanel guiComponent;
    private final JCheckBox useFilter;
    private final SpinnerNumberModel daysAgoSpinnerModel;
    private final JSpinner daysAgoSpinner;

    public DaysAgoSearchField(String searchFieldLabel, Action refreshAction, ComparisonSearchFilter<Date> comparisonFilter) {
        super(searchFieldLabel, null);
        this.comparisonFilter = comparisonFilter;
        this.guiComponent = new JPanel(new GridLayout(1, 3));
        this.useFilter = new JCheckBox();
        this.useFilter.setName(searchFieldLabel);
        this.daysAgoSpinnerModel = new SpinnerNumberModel(3, 0, 9999, 1);
        this.daysAgoSpinner = new JSpinner(this.daysAgoSpinnerModel);
        this.daysAgoSpinner.setName("days ago");
        JLabel daysAgoLabel = new JLabel("days ago");
        daysAgoLabel.setLabelFor(this.daysAgoSpinner);
        this.guiComponent.add(this.useFilter);
        this.guiComponent.add(this.daysAgoSpinner);
        this.guiComponent.add(daysAgoLabel);
        this.addAction(refreshAction);
    }

    @Override
    public Component getGuiComponent() {
        return this.guiComponent;
    }

    @Override
    public void addAction(final Action action) {
        if (this.useFilter != null) {
            this.useFilter.addActionListener(action);
        }
        if (this.daysAgoSpinner != null) {
            this.daysAgoSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    action.actionPerformed(null);
                }
            });
        }
    }

    @Override
    public void reset() {
        this.useFilter.setSelected(false);
    }

    @Override
    public SearchFilterI getSearchProperty() {
        if (this.isEnabled() && this.useFilter.isSelected()) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, this.daysAgoSpinnerModel.getNumber().intValue() * -1);
            this.comparisonFilter.setSearchValue(cal.getTime());
        } else {
            this.comparisonFilter.setSearchValue(null);
        }
        return this.comparisonFilter;
    }

    @Override
    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
        if (!flag) {
            this.comparisonFilter.setSearchValue(null);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

