/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.gui.adminkit.AdminGuiUtils;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.offset.DateOffsetFunction;
import au.com.ordermate.search.searchfield.java.AbstractDateRangeSearchField;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Action;
import org.jdesktop.swingx.JXDatePicker;

public class FixedDateRangeSearchField
extends AbstractDateRangeSearchField {
    private final DateOffsetFunction dayOffsetFunc;
    private final JXDatePicker datePicker = AdminGuiUtils.getInstance().standardDatePickerSetup(new JXDatePicker(new Date()));

    public FixedDateRangeSearchField(String label, IRangedQuerySearchFilter<Date> prop, DateOffsetFunction dateOffsetFunction, Action refreshAction) {
        super(label, prop, refreshAction);
        this.dayOffsetFunc = dateOffsetFunction;
        this.datePicker.addActionListener((ActionListener)refreshAction);
    }

    @Override
    public Component getGuiComponent() {
        return this.datePicker;
    }

    @Override
    public void addAction(Action action) {
        if (this.datePicker != null) {
            this.datePicker.addActionListener((ActionListener)action);
        }
    }

    @Override
    public void reset() {
        this.datePicker.setDate(new Date());
    }

    @Override
    public IRangedSearchFilter<Date> getSearchProperty() {
        SearchFilterI searchProp = super.getSearchProperty();
        Date start = this.datePicker.getDate();
        if (this.isEnabled()) {
            searchProp.setStart(start);
            searchProp.setEnd(this.dayOffsetFunc.calcOffset(start));
        } else {
            searchProp.setStart(null);
            searchProp.setEnd(null);
        }
        return searchProp;
    }

    @Override
    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
    }

    @Override
    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

