/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.gui.adminkit.AdminGuiUtils;
import au.com.ordermate.oquery.search.filter.implementation.FrequentCustomerSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXDatePicker;

public class FrequentCustomerSearchField
extends SearchGuiField
implements ActionListener {
    private JPanel searchFieldPanel = new JPanel(new FlowLayout());
    private JComboBox rangeTypeComboBox;
    private JComboBox missingComboBox;
    private JSpinner rangeSpinner;
    private JXDatePicker startDate;
    private EventComboBoxModel rangeTypeModel;
    private EventComboBoxModel missingModel;
    private SpinnerNumberModel rangeSpinnerModel;
    private static final int SPINNER_MODEL_MIN = 2;
    private static final int SPINNER_MODEL_MAX = 10;
    private final FrequentCustomerSearchFilter searchFilter;

    public FrequentCustomerSearchField(String searchFieldLabel, FrequentCustomerSearchFilter searchProp, Action refreshAction, EventList dataList, EventList dataList2, Format formatter) {
        super(searchFieldLabel, null);
        this.searchFieldPanel.setName(searchFieldLabel);
        this.rangeTypeComboBox = new JComboBox();
        this.rangeTypeComboBox.setName(searchFieldLabel + "RangeTypeComboBox");
        this.missingComboBox = new JComboBox();
        this.missingComboBox.setName(searchFieldLabel + "MissingComboBox");
        this.rangeSpinner = new JSpinner();
        this.rangeSpinner.setName(searchFieldLabel + "RangeSpinner");
        AdminGuiUtils.getInstance().standardSpinnerSetup(this.rangeSpinner);
        this.startDate = new JXDatePicker();
        this.startDate.setName(searchFieldLabel + "StartDate");
        AdminGuiUtils.getInstance().standardDatePickerSetup(this.startDate);
        if (formatter != null) {
            this.rangeTypeComboBox.setRenderer(this.createRenderer(formatter));
            this.missingComboBox.setRenderer(this.createRenderer(formatter));
            this.rangeTypeComboBox.setEditable(false);
            this.missingComboBox.setEditable(false);
        }
        JPanel rangeSpinnerPanel = new JPanel();
        rangeSpinnerPanel.add(this.rangeSpinner);
        this.searchFieldPanel.add(rangeSpinnerPanel);
        this.searchFieldPanel.add(this.rangeTypeComboBox);
        this.searchFieldPanel.add(this.missingComboBox);
        JPanel startDatePanel = new JPanel();
        startDatePanel.add(new JLabel("Start date:"));
        startDatePanel.add((Component)this.startDate);
        this.startDate.getEditor().setName("startDateField");
        this.searchFieldPanel.add(startDatePanel);
        this.addAction(refreshAction);
        this.searchFilter = searchProp;
        this.setRangeTypeComboListData(dataList);
        this.setSubComboListData(dataList2);
        this.rangeSpinner.setModel(new SpinnerNumberModel(2, 2, 10, 1));
        this.startDate.setDate(this.todayDate());
        this.rangeTypeComboBox.setSelectedIndex(0);
        this.missingComboBox.setSelectedIndex(0);
        this.setDateRange();
        this.rangeTypeComboBox.addActionListener(this);
        this.missingComboBox.addActionListener(this);
        this.startDate.addActionListener((ActionListener)this);
    }

    public FrequentCustomerSearchField(String searchFieldLabel, FrequentCustomerSearchFilter searchProp, Action refreshAction, EventList dataList, EventList dataList2) {
        this(searchFieldLabel, searchProp, refreshAction, dataList, dataList2, null);
    }

    public void setRangeTypeComboListData(EventList data) {
        this.rangeTypeModel = new EventComboBoxModel(data);
        this.rangeTypeComboBox.setModel(this.rangeTypeModel);
    }

    public void setSubComboListData(EventList data) {
        this.missingModel = new EventComboBoxModel(data);
        this.missingComboBox.setModel(this.missingModel);
    }

    protected JComboBox getRangeTypeComboBox() {
        return this.rangeTypeComboBox;
    }

    protected JComboBox getMissingComboBox() {
        return this.missingComboBox;
    }

    protected JSpinner getRangeSpinner() {
        return this.rangeSpinner;
    }

    public JXDatePicker getStartDatePicker() {
        return this.startDate;
    }

    @Override
    public Component getGuiComponent() {
        return this.searchFieldPanel;
    }

    @Override
    public void addAction(final Action action) {
        if (action != null) {
            this.rangeTypeComboBox.addActionListener(action);
            this.missingComboBox.addActionListener(action);
            this.startDate.addActionListener((ActionListener)action);
            if (this.rangeSpinner != null) {
                this.rangeSpinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        action.actionPerformed(null);
                    }
                });
            }
        }
    }

    @Override
    public void reset() {
        if (this.rangeTypeModel.getSize() > 0) {
            this.getRangeTypeComboBox().setSelectedIndex(0);
        }
        if (this.missingModel.getSize() > 0) {
            this.getMissingComboBox().setSelectedIndex(0);
        }
        this.getStartDatePicker().setDate(this.todayDate());
        this.getRangeSpinner().setValue(2);
    }

    @Override
    public SearchFilterI getSearchProperty() {
        return this.searchFilter;
    }

    @Override
    public void setVisible(boolean flag) {
        this.rangeTypeComboBox.setVisible(flag);
        this.missingComboBox.setVisible(flag);
        this.rangeSpinner.setVisible(flag);
        this.startDate.setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.rangeTypeComboBox.isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.rangeTypeComboBox.setEnabled(flag);
        this.missingComboBox.setEnabled(flag);
        this.rangeSpinner.setEnabled(flag);
        this.startDate.setEnabled(flag);
        if (!flag) {
            this.searchFilter.clearSearch();
        } else {
            this.setDateRange();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.rangeTypeComboBox.isEnabled();
    }

    private ListCellRenderer createRenderer(final Format formatter) {
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                comp.setText(value == null ? null : formatter.format(value));
                return comp;
            }
        };
        return renderer;
    }

    private Date todayDate() {
        GregorianCalendar today = new GregorianCalendar();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        return today.getTime();
    }

    private void setDateRange() {
        Date[] dateRange = new Date[2];
        dateRange[0] = this.startDate.getDate();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dateRange[0]);
        ((Calendar)cal).add(((FrequentCustomerSearchFilter.UnitOfTime)((Object)this.rangeTypeComboBox.getSelectedItem())).getCalendarField(), ((Number)this.rangeSpinner.getValue()).intValue());
        dateRange[1] = cal.getTime();
        this.searchFilter.setStart(dateRange[0]);
        this.searchFilter.setEnd(dateRange[1]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.rangeTypeComboBox) {
            this.searchFilter.setRangeType((FrequentCustomerSearchFilter.UnitOfTime)((Object)this.rangeTypeComboBox.getSelectedItem()));
            this.setDateRange();
        } else if (source == this.missingComboBox) {
            this.searchFilter.setSearchType((FrequentCustomerSearchFilter.FrequentCustomerSearchType)((Object)this.missingComboBox.getSelectedItem()));
        } else if (source == this.rangeSpinner) {
            this.setDateRange();
        } else if (source == this.startDate) {
            this.setDateRange();
        }
    }
}

