/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.oquery.FullTextSearch;
import au.com.ordermate.oquery.search.filter.implementation.FullTextJointSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JTextField;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class FullTextStringSearchField
extends SearchGuiField {
    private JTextField textField;
    private FullTextJointSearchFilter searchFilter;

    public FullTextStringSearchField(String name, FullTextSearch.FullTextIndex newIndex) {
        this(name, newIndex, null);
    }

    public FullTextStringSearchField(String name, FullTextJointSearchFilter newFilter) {
        this(name, newFilter, null);
    }

    public FullTextStringSearchField(String name, FullTextSearch.FullTextIndex newIndex, Action action) {
        this(name, new FullTextJointSearchFilter(newIndex), action);
    }

    public FullTextStringSearchField(String name, FullTextJointSearchFilter newFilter, Action action) {
        super(name, action);
        this.searchFilter = newFilter;
        Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.getTextField(), (Property)BeanProperty.create((String)"text"), (Object)this, (Property)BeanProperty.create((String)"searchValue")).bind();
    }

    public FullTextStringSearchField(String name, FullTextSearch.FullTextIndex newIndex, Action action, boolean newOrderByRelevence, FullTextSearch.Mode searchMode) {
        this(name, new FullTextJointSearchFilter(newIndex, searchMode, newOrderByRelevence), action);
    }

    @Override
    public Component getGuiComponent() {
        return this.getTextField();
    }

    @Override
    public void reset() {
        this.getTextField().setText("");
    }

    @Override
    public void addAction(Action action) {
        if (action != null) {
            this.getTextField().getDocument().addDocumentListener(new SearchGuiField.DocumentListenerAdapter(action));
        }
    }

    public void addActionToTextField(Action action) {
        this.getTextField().addActionListener(action);
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField(15);
            this.textField.setName(this.getLabel());
        }
        return this.textField;
    }

    public synchronized void setSearchValue(Object value) {
        String searchValue = (String)value;
        if ("".equals(value)) {
            searchValue = null;
        }
        this.searchFilter.setString(searchValue);
    }

    @Override
    public SearchFilterI getSearchProperty() {
        if (this.isEnabled()) {
            this.searchFilter.setString(this.textField.getText());
        } else {
            this.searchFilter.setString(null);
        }
        return this.searchFilter;
    }

    @Override
    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
        if (!flag) {
            this.searchFilter.setString(null);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

